disp(['Running Postprocess Script: ' mfilename]);

if exist('obj','var') && ~exist('sim_batch','var')
    sim_batch = obj;
end

if sim_batch.logging_config.has_package('REVS_log_fuel_economy')
    
    %try
        pause(1);
        
        datagrabber(sim_batch.output_file.name,'structure','spreadbase','headerline',1,'dataline',3,'quiet');
        
        spreadbase.Key = strrep(spreadbase.Key,'#',',');
        
        % find performance baselines
        performance_cases   = [];
        output_cases        = [];
        num_baselines       = 0;
        num_perf_cases      = 0;
        
        if isfield(spreadbase,'total_performance_sec') && isfield(spreadbase,'Perf_Baseline') && isfield(spreadbase,'Perf_Neutral')

			spreadbase.Perf_Baseline(isnan(spreadbase.Perf_Baseline)) = 0;
			spreadbase.Perf_Neutral(isnan(spreadbase.Perf_Neutral)) = 0;
			
			for i = 1:length(spreadbase.Key)
                if spreadbase.Perf_Baseline(i) % || (~spreadbase.Perf_Baseline(i) && ~spreadbase.Perf_Neutral(i))
                    num_baselines = num_baselines + 1;
                    num_perf_cases = 1;
                    performance_cases(num_baselines, num_perf_cases) = i; %#ok<SAGROW>
                end
                
                if (~spreadbase.Perf_Baseline(i) && ~spreadbase.Perf_Neutral(i))
                    output_cases = [output_cases i]; %#ok<*AGROW>
                end
                
                if spreadbase.Perf_Neutral(i)
                    if num_baselines == 0
                        warning('No Performance Baseline Established');
                    else
                        num_perf_cases = num_perf_cases + 1;
                        performance_cases(num_baselines, num_perf_cases) = i; %#ok<SAGROW>
                    end
                end
            end
        end
        
        if num_baselines > 0
            for b = 1:num_baselines
                performance_sweep_group = performance_cases(b, find(performance_cases(b,:))); %#ok<FNDSB>
                output_cases = [output_cases performance_sweep_group(1)]; %#ok<*AGROW>
                
                if length(performance_sweep_group) > 1
                    performance_sub_cases = performance_sweep_group(2:end);
                    sweep_config_keys = spreadbase.Unique_Key(performance_sub_cases);
                    
                    unique_sweep_keys = unique(spreadbase.Unique_Key(performance_sub_cases));
                                
                    for i = 1:length(unique_sweep_keys)
                        key_matches = find(sweep_config_keys == unique_sweep_keys(i));
                        if length(key_matches) == 1
                            key_matches = {key_matches};
                        end
                        
                        best_sweep_case = NaN;
                        best_perf_ghg = inf;
                        best_perf = inf;
                        
                        if length(key_matches) > 1
                             for n = performance_sub_cases(key_matches)
                                
%                                key_num = unique_sweep_keys(i);                                
%                                if ~isempty( strfind( sim_batch.expanded_config_set{n}, ['UKN:' num2str(key_num)] ))
                                    if (spreadbase.total_performance_sec(n) <= best_perf(1))
                                        best_perf = [spreadbase.total_performance_sec(n), n];
                                    end
                                    
                                    perf_GHG = spreadbase.Combined_GHG_gCO2_mi(n);
                                    
                                    if (spreadbase.total_performance_sec(n) <= spreadbase.total_performance_sec(performance_sweep_group(1))) && ...
                                            (perf_GHG <= best_perf_ghg(1))
                                        best_perf_ghg = [perf_GHG, n];
                                        best_sweep_case = n;
                                    end
%                                end
                            end
                            
                            if isnan(best_sweep_case)
                                best_sweep_case = best_perf(2);
                            end
                        else
                            best_sweep_case = performance_sub_cases(~cellfun(@isempty,key_matches));
                        end
                        
                        output_cases = [output_cases best_sweep_case];
                        
                    end
                end
            end
        end
        
        %% write selected results to file...
        if ~isempty(output_cases)
            input_fid = fopen(sim_batch.output_file.name);
            %output_fid = fopen(sim_batch.gen_output_filename(false, [sim_batch.output_file.descriptor '_perf_neutral']),'w');
            [output_fid, err_msg] = fopen(strrep(sim_batch.output_file.name,'_results','_perf_neutral_results'),'a+');  % was w+
            
            % write header
            fprintf(output_fid, '%s\n', fgetl(input_fid));
            fprintf(output_fid, '%s\n', fgetl(input_fid));
            
            for i = 1:length(spreadbase.Key)
                if ismember(spreadbase.Configuration(i), output_cases)
                    fprintf(output_fid, '%s\n', fgetl(input_fid));    % copy line to results file
                else
                    fgetl(input_fid);  % discard line
                end
            end
            
            fclose(input_fid);
            fclose(output_fid);
        end
%     catch
% %        fclose(input_fid);
% %        fclose(output_fid);
%         
%         error('Couldn''t process results file (probably datagrabber error)');
%     end
end