
if REVS.verbose 
    disp(['Running Preprocess Script: ' mfilename]); 
end

%% powertrain type
if sim_config.powertrain_type.has_value
    vehicle.powertrain_type = eval(['enum_powertrain_type.' sim_config.powertrain_type]);
end

%% external sim stimuli

if sim_config.test_data.has_value && contains(sim_config.test_data.value, '.mat')
    load(sim_config.test_data.value)
    sim_config.test_data.value = strrep(sim_config.test_data.value, '.mat', '');
end

if sim_config.external_accessory_elec.has_value % && sim_config.external_drive_cycle.value
    accessories.generic_loss                                            = class_REVS_accessory_load();
    accessories.generic_loss.electrical_loss_map_A.axis_1.signal        = 'cycle_pos_secs';
    accessories.generic_loss.electrical_loss_map_A.axis_1.breakpoints   = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
    accessories.generic_loss.electrical_loss_map_A.table = []; % clear table
    accessories.generic_loss.electrical_loss_map_A.table(:,1)           = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').' sim_config.external_accessory_elec.value ';']);
end

if sim_config.external_accessory_mech.has_value % && sim_config.external_drive_cycle.value
    
end

if sim_config.external_drive_cycle.has_value && sim_config.external_drive_cycle.value
    if sim_config.external_drive_cycle.value == 1
        % user should load canonical cycle to provide bags/phase times etc,
        % but override vehicle speed with new data
        drive_cycle.cycle_time      = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
        drive_cycle.cycle_speed_mps = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').vehicle.dyno_speed_mps;']);
    else
        % create entirely new drive cycle (single bag)
        cycle_time      = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
        cycle_speed_mps = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').vehicle.dyno_speed_mps;']);
        drive_cycle = REVS_create_drive_cycle('external_cycle', cycle_speed_mps, cycle_time);
    end
end

if sim_config.external_shift.has_value && sim_config.external_shift.value
	if transmission.type == enum_transmission_type.CVT
		transmission.gear_strategy = class_REVS_external_shift_CVT;
		transmission.gear_strategy.time_secs = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
		transmission.gear_strategy.CVT_ratio = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').transmission.commanded_CVT_ratio;']);
	else
		transmission.gear_strategy = class_REVS_external_shift;
		transmission.gear_strategy.time_secs = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
		transmission.gear_strategy.gear_num  = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').transmission.commanded_gear_number;']);
	end
end

if sim_config.external_lockup.has_value && sim_config.external_lockup.value
    transmission.tcc_strategy           = class_REVS_external_lockup;
    transmission.tcc_strategy.time_secs = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
    transmission.tcc_strategy.lockup_cmd   = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').transmission.launch_device_lockup_norm;']);
end

if sim_config.external_trans_temp.has_value && sim_config.external_trans_temp.value
    transmission.thermal.temperature_time_sec = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
    transmission.thermal.temperature_degC = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').transmission.oil_temp_degC;']);
end

if sim_config.external_cyl_deac.has_value && sim_config.external_cyl_deac.value
    engine.deac_strategy.type = enum_engine_deac_select.external_deac;
	engine.deac_strategy.time_secs = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').time;']);
	engine.deac_strategy.deac_norm = evalin('base',[sim_config.test_data.value '(' num2str(sim_config.test_data_index.value) ').engine.cylinder_deac_norm;']);
end

%% base roadload

if sim_config.roadload_multiplier.has_value
    roadload_multiplier = sim_config.roadload_multiplier.value;
else
    roadload_multiplier = 1.0;
end

if sim_config.target_A_lbs.has_value
    vehicle.coastdown_target_A_lbf = sim_config.target_A_lbs.value * roadload_multiplier;
end

if sim_config.target_B_lbs.has_value
    vehicle.coastdown_target_B_lbfpmph = sim_config.target_B_lbs.value * roadload_multiplier;
end

if sim_config.target_C_lbs.has_value
    vehicle.coastdown_target_C_lbfpmph2 = sim_config.target_C_lbs.value * roadload_multiplier;
end

if sim_config.target_A_N.has_value
    vehicle.coastdown_target_A_N = sim_config.target_A_N.value * roadload_multiplier;
end

if sim_config.target_B_N.has_value
    vehicle.coastdown_target_B_Npms = sim_config.target_B_N.value * roadload_multiplier;
end

if sim_config.target_C_N.has_value
    vehicle.coastdown_target_C_Npms2 = sim_config.target_C_N.value * roadload_multiplier;
end

%% dyno sets
if sim_config.dyno_set_A_lbs.has_value
    vehicle.dyno_set_A_lbf = sim_config.dyno_set_A_lbs.value;
end

if sim_config.dyno_set_B_lbs.has_value
    vehicle.dyno_set_B_lbfpmph = sim_config.dyno_set_B_lbs.value;
end

if sim_config.dyno_set_C_lbs.has_value
    vehicle.dyno_set_C_lbfpmph2 = sim_config.dyno_set_C_lbs.value;
end

if sim_config.dyno_set_A_N.has_value
    vehicle.dyno_set_A_N = sim_config.dyno_set_A_N.value;
end

if sim_config.dyno_set_B_N.has_value
    vehicle.dyno_set_B_Npms = sim_config.dyno_set_B_N.value;
end

if sim_config.dyno_set_C_N.has_value
    vehicle.dyno_set_C_Npms2 = sim_config.dyno_set_C_N.value;
end

if sim_config.calc_ABC_adjust.value
    % calculate roadload adjustment from targets and dyno sets
    vehicle = vehicle.calc_roadload_adjust();
else
    %% roadload adjustment
    if sim_config.adjust_A_lbs.has_value
        vehicle.coastdown_adjust_A_lbf = sim_config.adjust_A_lbs.value;
    end

    if sim_config.adjust_B_lbs.has_value
        vehicle.coastdown_adjust_B_lbfpmph = sim_config.adjust_B_lbs.value;
    end

    if sim_config.adjust_C_lbs.has_value
        vehicle.coastdown_adjust_C_lbfpmph2 = sim_config.adjust_C_lbs.value;
    end

    if sim_config.adjust_A_N.has_value
        vehicle.coastdown_adjust_A_N = sim_config.adjust_A_N.value;
    end

    if sim_config.adjust_B_N.has_value
        vehicle.coastdown_adjust_B_Npms = sim_config.adjust_B_N.value;
    end

    if sim_config.adjust_C_N.has_value
        vehicle.coastdown_adjust_C_Npms2 = sim_config.adjust_C_N.value;
    end
end

%% test weight/mass
if sim_config.ETW_lbs.has_value
    vehicle.ETW_lbs = sim_config.ETW_lbs.value;
end

if sim_config.ETW_kg.has_value
    vehicle.ETW_kg  = sim_config.ETW_kg.value;
end

if sim_config.vehicle_lbs.has_value
    vehicle.mass_static_kg  = unit_convert.lbm2kg * sim_config.vehicle_lbs.value;
end

if sim_config.vehicle_kg.has_value
    vehicle.mass_static_kg  = sim_config.vehicle_kg.value;
end

if sim_config.mass_multiplier.has_value
    vehicle.mass_static_kg  = vehicle.mass_static_kg * sim_config.mass_multiplier.value;
    vehicle.mass_dynamic_kg = vehicle.mass_dynamic_kg * sim_config.mass_multiplier.value;
end

%% performance weight penalty
if sim_config.performance_mass_penalty_kg.has_value
    temp.perf_phase_num = find(contains(lower(drive_cycle.phase_name),'performance'),1);
    
    if ~isempty(temp.perf_phase_num)
        temp.perf_phase_start = drive_cycle.phase_time(drive_cycle.phase == temp.perf_phase_num);
                
        % should set penalty back to zero after performance cycle... in
        % case it's not the last part of the cycle...
        vehicle.delta_mass_static_kg.axis_1.signal      = 'cycle_pos_secs';
        vehicle.delta_mass_static_kg.axis_1.breakpoints = [temp.perf_phase_start, temp.perf_phase_start + .001 ];
        vehicle.delta_mass_static_kg.table              = [0, sim_config.performance_mass_penalty_kg.value];
        
        vehicle.delta_mass_dynamic_kg.axis_1.signal      = 'cycle_pos_secs';
        vehicle.delta_mass_dynamic_kg.axis_1.breakpoints = [temp.perf_phase_start, temp.perf_phase_start + .001 ];
        vehicle.delta_mass_dynamic_kg.table              = [0, sim_config.performance_mass_penalty_kg.value];
    end
    
    clear temp
end

%% final drive ratio (absolute)
if sim_config.FDR.has_value
    vehicle.drive_axle1.final_drive.gear_ratio = sim_config.FDR.value;
end

%% final drive ratio efficiency
if sim_config.FDR_efficiency_norm.has_value
    vehicle.drive_axle1.final_drive.efficiency_norm = sim_config.FDR_efficiency_norm.value;
end

%% start stop
if sim_config.start_stop.has_value
    controls.start_stop_enable = sim_config.start_stop.value;
end

%% roadload reductions
if sim_config.weight_reduction.has_value
    weight_reduction = sim_config.weight_reduction.value / 100;
else
    weight_reduction = 0;
end

if sim_config.improve_aero.has_value
    improve_aero = sim_config.improve_aero.value / 100;
else
    improve_aero = 0;
end

if sim_config.improve_crr.has_value
    improve_crr = sim_config.improve_crr.value / 100;
else
    improve_crr = 0;
end

vehicle = matrix_calc_roadload(vehicle, weight_reduction, improve_aero, improve_crr);

%% fuel normalization
if sim_config.normalize_fuel.has_value
    % scale engine BSFC based on reference fuel energy density:
    reference_fuel      = class_REVS_fuel(sim_config.normalize_fuel.value);
    engine.fuel_map_gps = engine.fuel_map_gps * engine.fuel.energy_density_MJpkg / reference_fuel.energy_density_MJpkg;
    engine.fuel         = reference_fuel;
    
    vehicle.fuel        = reference_fuel;
elseif isempty(vehicle.fuel) && exist('engine','var')
    vehicle.fuel        = engine.fuel;
end

%% performance scaling
perf_scale = 1.0;
if sim_config.performance_baseline.has_value && sim_config.performance_baseline.value

    % calc performance baseline
    if sim_config.engine_scale_kW.has_value
        temp_engine_scale_norm = (sim_config.engine_scale_kW.value * 1000) / engine.max_power_W;
    elseif sim_config.engine_scale_hp.has_value
        temp_engine_scale_norm = (sim_config.engine_scale_hp.value * unit_convert.hp2kW * 1000) / engine.max_power_W;
    elseif sim_config.engine_scale_pct.has_value
        temp_engine_scale_norm = (sim_config.engine_scale_pct.value / 100);
    elseif sim_config.engine_scale_L.has_value
        temp_engine_scale_norm = sim_config.engine_scale_L.value / engine.displacement_L;
    else
        temp_engine_scale_norm = 1.0;
    end
    
    temp_engine                 = REVS_modify_engine( engine, 'scale_factor', temp_engine_scale_norm, 'no_scale_fuel_adjust');    % baseline engine scaling
    redline_rpm                 = min(temp_engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(temp_engine, 0.98, 'min')) * unit_convert.radps2rpm;
    [~, baseline_wheelpower_W]  = REVS_calc_max_wheeltorque( temp_engine, transmission, vehicle.drive_axle1, 'stall_radps', 1 * 3000 * unit_convert.rpm2radps, 'redline_radps', redline_rpm * unit_convert.rpm2radps, 'max_speed_mph', 70); %, 'do_plots' );
    
    % store baseline perf in global var
    obj.batch_sim_ptr.globals.baseline_wheel_perf = sum(baseline_wheelpower_W);
    
    clear temp_engine temp_engine_scale baseline_wheelpower_W;
elseif sim_config.performance_neutral.has_value && sim_config.performance_neutral.value && isfield(obj.batch_sim_ptr.globals,'baseline_wheel_perf')
    redline_rpm = min(engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(engine, 0.98, 'min')) * unit_convert.radps2rpm;
    
    % scale for performance:
    [wheeltorque_Nm, wheelpower_W] = REVS_calc_max_wheeltorque( engine, transmission, vehicle.drive_axle1, 'stall_radps', 1 * 3000 * unit_convert.rpm2radps, 'redline_radps', redline_rpm * unit_convert.rpm2radps, 'max_speed_mph', 70); %, 'do_plots' );
    wheel_perf          = sum(wheelpower_W);
    perf_scale          = obj.batch_sim_ptr.globals.baseline_wheel_perf / wheel_perf;
    
    % scale for roadload and boost:
    boost_ratio         = max(engine.full_throttle_torque_Nm)/max(engine.naturally_aspirated_torque_Nm)-1;
    perf_scale          = perf_scale * (1 + boost_ratio/20) * (1 - weight_reduction * 0.88) * (1 - improve_crr * 0.02) * (1 - improve_aero * 0.03); % * (1 - (transmission.matrix_vintage == enum_matrix_vintage.future) * 0.066);
    
    clear wheel_perf boost_ratio
elseif sim_config.performance_neutral.has_value && sim_config.performance_neutral.value && ~isfield(obj.batch_sim_ptr.globals,'baseline_wheel_perf')
    error('Performance Baseline Unavailable');
end

%% engine (re)scaling
if sim_config.engine_scale_kW.has_value && (~sim_config.performance_neutral.has_value ||  ~sim_config.performance_neutral.value)
    engine_scale_norm = perf_scale * (sim_config.engine_scale_kW.value * 1000) / engine.max_power_W;
elseif sim_config.engine_scale_hp.has_value
    engine_scale_norm = perf_scale * (sim_config.engine_scale_hp.value * unit_convert.hp2kW * 1000) / engine.max_power_W;
elseif sim_config.engine_scale_L.has_value
    engine_scale_norm = sim_config.engine_scale_L.value / engine.displacement_L;
elseif sim_config.engine_scale_pct.has_value % [default = 100]
    engine_scale_norm = perf_scale * (sim_config.engine_scale_pct.value / 100);
else
    engine_scale_norm = perf_scale;
end

if (abs(engine_scale_norm - 1) > 0.001) || (sim_config.engine_scale_num_cylinders.has_value && (sim_config.engine_scale_num_cylinders.value ~= engine.num_cylinders))
    
    if sim_config.engine_scale_BSFC.has_value && ~sim_config.engine_scale_BSFC.value
        engine = REVS_modify_engine( engine, 'scale_factor', engine_scale_norm, 'no_scaling_knock_adjust', 'no_scaling_friction_adjust', 'no_scaling_sv_ratio_adjust', 'num_cylinders', sim_config.engine_scale_num_cylinders.value, 'knock_max_adjust', 1.2);
    else
        engine = REVS_modify_engine( engine, 'scale_factor', engine_scale_norm, 'num_cylinders', sim_config.engine_scale_num_cylinders.value, 'knock_max_adjust', 1.5);
    end
    
end

%% engine tech modifiers

	
	mod_engine_args = {};
	
    
    if sim_config.engine_deac_C_cyl_pct.has_value && sim_config.engine_deac_C_cyl_pct.value > 0
        % Add continuous deac (all cylinders)
		mod_engine_args{end+1} = '+deacC';
    elseif sim_config.engine_deac_D_cyl_pct.has_value && sim_config.engine_deac_D_cyl_pct.value > 0
        % Add discrete deac to portion of cylinders
		mod_engine_args{end+1} = '+deacD';
        mod_engine_args{end+1} = 'deac_cylinders';
		mod_engine_args{end+1} = round(sim_config.engine_deac_D_cyl_pct.value/100* engine.num_cylinders);
    elseif sim_config.engine_deac_D_cyl.has_value && sim_config.engine_deac_D_cyl.value > 0
        % Add discrete deac to portion of cylinders
		mod_engine_args{end+1} = '+deacD';
        mod_engine_args{end+1} = 'deac_cylinders';
		mod_engine_args{end+1} = sim_config.engine_deac_D_cyl.value;
    elseif sim_config.engine_deac_C_cyl_pct.has_value || sim_config.engine_deac_D_cyl_pct.has_value || sim_config.engine_deac_D_cyl.has_value
        % A deac value of 0 (or less) was specified - remove any if present
        mod_engine_args{end+1} = '-deac';
    end
	

	
	if sim_config.engine_deac_activation_delay_secs.has_value
		mod_engine_args{end+1} = 'deac_activation_secs';
		mod_engine_args{end+1} = sim_config.engine_deac_activation_delay_secs.value;
	end
	
	if sim_config.engine_deac_max_reduction_pct.has_value
		mod_engine_args{end+1} = 'deac_max_reduction';
		mod_engine_args{end+1} = sim_config.engine_deac_max_reduction_pct.value/100;
	end
	
	if sim_config.engine_deac_reduction_curve.has_value
		mod_engine_args{end+1} = 'deac_reduction_curve';
		mod_engine_args{end+1} = eval(sim_config.engine_deac_reduction_curve.value);
	end
	
	if sim_config.engine_GDI.has_value
		mod_engine_args{end+1} = 'GDI';
		mod_engine_args{end+1} = sim_config.engine_GDI.value;
	end
	
	if sim_config.engine_DCP_DVVL.has_value
		mod_engine_args{end+1} = 'DCP_DVVL';
		mod_engine_args{end+1} = sim_config.engine_DCP_DVVL.value;
	end
	
	if sim_config.engine_DCP_CVVL.has_value
		mod_engine_args{end+1} = 'CCP_DVVL';
		mod_engine_args{end+1} = sim_config.engine_CCP_DVVL.value;
	end
	
	if sim_config.engine_DCP_CVVL.has_value
		mod_engine_args{end+1} = 'DCP_CVVL';
		mod_engine_args{end+1} = sim_config.engine_DCP_CVVL.value;
	end
	
	if sim_config.engine_DCP.has_value
		mod_engine_args{end+1} = 'DCP';
		mod_engine_args{end+1} = sim_config.engine_DCP.value;
	end
	
	if sim_config.engine_CCP.has_value
		mod_engine_args{end+1} = 'CCP';
		mod_engine_args{end+1} = sim_config.engine_CCP.value;
	end
	
	
	if exist('engine','var')
        engine = REVS_modify_engine( engine, mod_engine_args{:} );
%     engine = REVS_modify_engine2( engine, '+deacD', sim_config.engine_deac_D_cyl_pct.value/100,'+deacC', sim_config.engine_deac_C_cyl_pct.value/100, 'deac_activation_secs', sim_config.engine_deac_activation_delay_secs.value, 'deac_max_reduction', sim_config.engine_deac_max_reduction_pct.value/100   ,'GDI', sim_config.engine_GDI.value, 'DCP_DVVL', sim_config.engine_DCP_DVVL.value, 'CCP_DVVL', sim_config.engine_CCP_DVVL.value, 'DCP_CVVL', sim_config.engine_DCP_CVVL.value, 'DCP', sim_config.engine_DCP.value, 'CCP', sim_config.engine_CCP.value );
    end

% clear perf_scale

%% cylinder deac
if sim_config.engine_deac_scale_pct.has_value
    if isa(engine.deac_strategy.enable_norm,'class_REVS_dynamic_lookup')
%        engine.deac_strategy.enable_norm.table = sim_config.engine_deac_scale_pct.value/100 * ones(size(engine.deac_strategy.enable_norm.table));
        engine.deac_strategy.enable_norm.table = sim_config.engine_deac_scale_pct.value/100 * engine.deac_strategy.enable_norm.table;
    else
        engine.deac_strategy.enable_norm = sim_config.engine_deac_scale_pct.value/100;
    end
end





%% update gear strategy cost map for new engine
if (transmission.type == enum_transmission_type.CVT && transmission.gear_strategy.type == enum_transmission_gear_select.ALPHAshift_CVT)
    transmission.gear_strategy = transmission.gear_strategy.update_min_bsfc_curve(engine);
elseif (transmission.type ~= enum_transmission_type.no_transmission && transmission.gear_strategy.type == enum_transmission_gear_select.ALPHAshift)
    transmission.gear_strategy = transmission.gear_strategy.update_cost_map(engine);
end

%% final drive ratio (displacement-based)
if sim_config.FDR_auto.has_value && sim_config.FDR_auto.value
    
    if sim_config.NV_ratio.has_value && sim_config.NV_ratio.value
        targetN_at60 = sim_config.NV_ratio.value * 60;
    else
        %    targetNV = interp1([-9999 1 2 3 4 5 6 7 9999],[2250, 2250, 1750, 1700, 1600, 1500, 1450, 1300, 1300], engine.displacement_L) - 250;
        targetN_at60 = interp1([-9999 1 2 3 4 5 6 7 9999],[2250, 2250, 1750, 1700, 1600, 1500, 1450, 1300, 1300], engine.displacement_L) - 250 * (transmission.matrix_vintage == enum_matrix_vintage.future);
        if (transmission.type == enum_transmission_type.DCT)
            targetN_at60 = 1.25 * targetN_at60; % DCTs a better off, considering performance neutrality, with higher FDR and smaller engine, 1.25x based on sensitivity study
        end
    end
    
    if (transmission.type == enum_transmission_type.CVT)        
        NVratio = targetN_at60 / (unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * transmission.gear.ratio(2) * 60);
    else
        NVratio = targetN_at60 / (unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * transmission.gear.ratio(end) * 60);
    end
    
    vehicle.drive_axle1.final_drive.gear_ratio = vehicle.drive_axle1.final_drive.gear_ratio * NVratio;
    clear targetNV NVratio
end

%% engine fuel penalties
if sim_config.fuel_penalty_enable.has_value && ~sim_config.fuel_penalty_enable.value
    engine.acceleration_penalty_gpradps2 = 0;
    engine.refuel_limit_gps = 0;
end

%% transmission torque rating
if sim_config.normalize_transmission_rated_torque.has_value && sim_config.normalize_transmission_rated_torque.value
    transmission = REVS_modify_transmission(transmission, 'rated_torque', engine.max_torque_Nm * 1.15);
end

%% torque converter torque ratio
if sim_config.TC_torque_ratio.has_value && isprop(transmission,'torque_converter')
    transmission.torque_converter.drive_torque_ratio    = interp1([0 0.875 1], [sim_config.TC_torque_ratio.value 1 1], transmission.torque_converter.speed_ratio);
end

%% torque converter K-factor
if sim_config.TC_K_factor.has_value && isprop(transmission,'torque_converter')
    % re-scale K-factor but maintain original K-factor v. SR curve:
    transmission.torque_converter.drive_k_factor_rpmpsqrtNm = sim_config.TC_K_factor.value * normalize(transmission.torque_converter.drive_k_factor_rpmpsqrtNm, 1);
    transmission.torque_converter.decel_k_factor_rpmpsqrtNm = 0.7*transmission.torque_converter.drive_k_factor_rpmpsqrtNm(1) + transmission.torque_converter.drive_k_factor_rpmpsqrtNm;
end

if sim_config.TC_K_factor_auto.has_value && sim_config.TC_K_factor_auto.value && isprop(transmission,'torque_converter')
    if strcmpi(sim_config.vehicle_type.value,'"Truck"')
        temp.stall_rpm = 3075;
    else
        temp.stall_rpm = 3250;
    end
    
    temp.stall_torque_Nm     = transmission.rated_torque_Nm; % interp1(engine.full_throttle_speed_radps*unit_convert.radps2rpm, engine.full_throttle_torque_Nm, temp.stall_rpm);
    temp.K_factor_rpmpsqrtNm = temp.stall_rpm/sqrt(temp.stall_torque_Nm);
    
    % re-scale K-factor but maintain original K-factor v. SR curve:
    transmission.torque_converter.drive_k_factor_rpmpsqrtNm = temp.K_factor_rpmpsqrtNm * normalize(transmission.torque_converter.drive_k_factor_rpmpsqrtNm, 1);
    transmission.torque_converter.decel_k_factor_rpmpsqrtNm = 0.7*transmission.torque_converter.drive_k_factor_rpmpsqrtNm(1) + transmission.torque_converter.drive_k_factor_rpmpsqrtNm;
    
    clear temp
end

%% torque converter lockup efficiency
if sim_config.TC_lockup_efficiency_pct.has_value && isprop(transmission,'torque_converter')
    transmission.torque_converter.lockup_efficiency_norm = sim_config.TC_lockup_efficiency_pct.value / 100;
end

%% propulsion battery initial SOC
if sim_config.propulsion_battery_initial_soc_norm.has_value
    electric.propulsion_battery.initial_soc_norm = sim_config.propulsion_battery_initial_soc_norm.value;
end

%% vintaging adjustments
if sim_config.engine_vintage.has_value
    engine.matrix_vintage = eval(['enum_matrix_vintage.' sim_config.engine_vintage.value]);
end

if sim_config.transmission_vintage.has_value
    transmission.matrix_vintage = eval(['enum_matrix_vintage.' sim_config.transmission_vintage.value]);
end

%% random variable
if sim_config.var.has_value && sim_config.var_value.has_value
    eval([sim_config.var.value ' = ' num2str(sim_config.var_value.value)]);
end

%% fix for hybrid powertrains
if vehicle.powertrain_type == enum_powertrain_type.hybrid_P0 || vehicle.powertrain_type == enum_powertrain_type.hybrid_P2 || vehicle.powertrain_type == enum_powertrain_type.hybrid_P2_BAS  %P2 added
    [controls.engine_min_bsfc_speed_radps, controls.engine_min_bsfc_torque_Nm] = REVS_calc_engine_min_bsfc(engine);
end

%% update controls (pedal map for new engine) (and min bsfc line)
if vehicle.powertrain_type == enum_powertrain_type.conventional
    controls = controls.update_powertrain_info(engine, transmission); % Might be needed in the future for EVs
end

if vehicle.powertrain_type == enum_powertrain_type.hybrid_powersplit
    controls = controls.update_powertrain_info(engine, transmission,electric,vehicle); % Might be needed in the future for EVs
end

%% custom eval	( this should always be last )
if sim_config.eval_value.has_value
    eval(sim_config.eval_value.value);
end
