%% FTP / combined results
% data_columns(end+1) = class_data_column({' ',' '},separator,'0');
% 
% for c = 1:length(result.weighted)
% 
%     cycle_name = result.weighted(c).cycle_name;
% 
%     if ~endsWith(cycle_name, 'PREP')
%     
%         data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
%         data_columns(end+1) = class_data_column({[cycle_name, ' Total VOL MPG'],    'VOL MPG'},     prec2_str,  ['result.weighted(', int2str(c), ').FE_vol_mpg'],   3);
%         data_columns(end+1) = class_data_column({[cycle_name, ' GHG gCO2/mi'],      'gCO2/mi'},     prec1_str,  ['result.weighted(', int2str(c), ').gCO2pmi'],      1);
%         
%         data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
%         data_columns(end+1) = class_data_column({[cycle_name, ' Electrical Consumption Wh/mi'],      'Wh/mi'},     prec1_str,  ['result.weighted(', int2str(c), ').energy_consumption_kWhp100mi.*10'], 1);
%         data_columns(end+1) = class_data_column({[cycle_name, ' NEC/Fuel'],                              '%'},     prec1_str,  ['result.weighted(', int2str(c), ').energy_consumption_fuel_pct'],      1);
% 
%     end
% end

%% phase vol MPG
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' VOL MPG'],'VOL MPG'},prec2_str,['result.phase.FE_raw_vol_mpg(' num2str(p) ')'],1);
    end
end

%% phase GHG
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' gCO2/mi'],'gCO2/mi'},prec1_str,['result.phase.gCO2pmi_raw(' num2str(p) ')'],1);
    end
end
%% phase fuel mass
data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' Fuel Consumed'],'g Fuel'},prec1_str,['result.phase.fuel_consumed_g(' num2str(p) ')'],2);
    end
end

%% phase electrical consumption
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' Electrical Consumption'],'Wh/mi'},prec1_str,['result.phase.energy_consumption_kWhp100mi(' num2str(p) ').*10'],1);
    end
end

%% phase MPGe
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({phase_names{p},'MPGe'},prec2_str,['result.phase.MPGe(' num2str(p) ')'],1);
    end
end

%% phase electtrical equivalent fuel
data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' Electrical Equivalent Fuel'],'g Fuel'},prec1_str,['result.phase.energy_consumed_equivalent_fuel_g(' num2str(p) ')'],2);
    end
end

%% NEC corrected phase fuel mass
data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' NEC Fuel Consumed'],'g Fuel'},prec1_str,['result.phase.NEC_fuel_consumed_g(' num2str(p) ')'],2);
    end
end

%% Electrical/Fuel %
data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' NEC/Fuel'],'%'},prec1_str,['result.phase.energy_consumption_fuel_pct(' num2str(p) ')'],2);
    end
end

%% phase distance
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' distance'],'miles'},prec3_str,['result.phase.distance_mi(' num2str(p) ')'],1);
    end
end

data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} ' time'],'secs'},prec2_str,['result.phase.time_secs(' num2str(p) ')'],2);
    end
end

%% Energy Corrected Results
data_columns(end+1) = class_data_column({' ',' '},separator,'0');
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({[phase_names{p} , ' VOL MPG (Net Energy Corrected)'], 'NEC MPG'}, prec2_str,  ['result.phase.FE_vol_mpg(',  num2str(p), ')'], 1);        
    end
end

data_columns(end+1) = class_data_column({' ',' '},separator,'0');
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)    
        data_columns(end+1) = class_data_column({[phase_names{p} , ' GHG gCO2/mi (Net Energy Corrected)'], 'NEC gCO2/mi'}, prec1_str,  ['result.phase.gCO2pmi(',  num2str(p), ')'], 1);        
    end
end

data_columns(end+1) = class_data_column({' ',' '},separator,'0', 2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)    
        data_columns(end+1) = class_data_column({[phase_names{p} , ' NEC/Fuel'], '%'}, prec1_str,  ['result.phase.energy_consumption_fuel_pct(',  num2str(p), ')'], 2);
    end
end
