%% FTP / combined results
data_columns(end+1) = class_data_column({' ',' '},separator,'0');

if isfield(postproc_results,'weighted_results')
    
    if isfield(postproc_results.weighted_results,'ftp_MPGe')
        data_columns(end+1) = class_data_column({'FTP Total','CFR MPG'},prec2_str,'postproc_results.weighted_results.ftp_MPGe',1);
    else
    %    data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
    end

    if isfield(postproc_results.weighted_results,'ftp_GHG_gCO2pmi')
        data_columns(end+1) = class_data_column({'FTP GHG','gCO2/mi'},prec1_str,'postproc_results.weighted_results.ftp_GHG_gCO2pmi',1);
    else
    %    data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
    end

    if isfield(postproc_results.weighted_results,'combined_CFR_mpg')
        data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
        data_columns(end+1) = class_data_column({'Combined FE','CFR MPG'},prec2_str,'postproc_results.weighted_results.combined_CFR_mpg',1);
    else
    %    data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
    end

    data_columns(end+1) = class_data_column({'Combined GHG','gCO2/mi'},prec1_str,'postproc_results.weighted_results.combined_GHG_gCO2pmi',1);


    if isfield(postproc_results.weighted_results,'udds_DC_kWhp100mi')
        data_columns(end+1) = class_data_column({'UDDS DC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.udds_DC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end
    
    if isfield(postproc_results.weighted_results,'udds_AC_kWhp100mi')
        data_columns(end+1) = class_data_column({'UDDS AC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.udds_AC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end
    
    if isfield(postproc_results.weighted_results,'ftp_DC_kWhp100mi')
        data_columns(end+1) = class_data_column({'FTP DC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.ftp_DC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end
    
    if isfield(postproc_results.weighted_results,'ftp_AC_kWhp100mi')
        data_columns(end+1) = class_data_column({'FTP AC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.ftp_AC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end
    
    
    if isfield(postproc_results.weighted_results,'us06_DC_kWhp100mi')
        data_columns(end+1) = class_data_column({'US06 DC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.us06_DC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end
    
    if isfield(postproc_results.weighted_results,'us06_AC_kWhp100mi')
        data_columns(end+1) = class_data_column({'US06 AC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.us06_AC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end  
    
    if isfield(postproc_results.weighted_results,'hwfet_DC_kWhp100mi')
        data_columns(end+1) = class_data_column({'HWFET DC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.hwfet_DC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end
    
    if isfield(postproc_results.weighted_results,'hwfet_AC_kWhp100mi')
        data_columns(end+1) = class_data_column({'HWFET AC kWhp100mi','kWh/100mi'},prec2_str,'postproc_results.weighted_results.hwfet_AC_kWhp100mi',3);
    else
    %     data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    end  
        


end



    
%% phase MPGe
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({phase_names{p},'DC MPGe'},prec2_str,['result.phase.MPGe(' num2str(p) ')'],1);
    end
end

%% phase Wh
data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({phase_names{p},'DC Wh'},prec2_str,['result.phase.energy_Wh(' num2str(p) ')'],2);
    end
end

%% phase kWhp100mi
data_columns(end+1) = class_data_column({' ',' '},separator,'0',2);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({phase_names{p},'DC kWhr/100mi'},prec1_str,['result.phase.energy_kWhp100mi(' num2str(p) ')'],2);
    end
end

%% phase Whpmi
data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
for p = 1:length(phase_names)
    if ~ismember(p, obj.output_restrict_phases)
        data_columns(end+1) = class_data_column({phase_names{p},'DC Whr/mi'},prec1_str,['result.phase.energy_kWhp100mi(' num2str(p) ') * 10'],1);
    end
end