%% Setup
if output_verbose < 3
    prec0_str = '%.0f';
    prec1_str = '%.1f';
    prec2_str = '%.2f';
    prec3_str = '%.3f';
    prec4_str = '%.4f';
    prec5_str = '%.5f';
else
    prec0_str = '%.0f';
    prec1_str = '%f';
    prec2_str = '%f';
    prec3_str = '%f';
    prec4_str = '%f';
    prec5_str = '%f';
end

separator = '---';

phase_names = drive_cycle.phase_name;
for p = 1:length(phase_names)
    try
        isnumeric(eval(drive_cycle.phase_name{p}));
        phase_names{p} = [drive_cycle.name '_' drive_cycle.phase_name{p}];  % if phase name is numeric, prepend drive cycle name
    catch
    end
end

%% Basic Vehicle Data
data_columns        = class_data_column({'Configuration','#'},'%d','sim_case');
data_columns(end+1) = class_data_column({'Vehicle Type',''},'%s','sim_config.vehicle_type',1);
% data_columns(end+1) = class_data_column({'Vehicle Manufacturer',''},'%s','sim_config.vehicle_manufacturer',3);
% data_columns(end+1) = class_data_column({'Vehicle Model',''},'%s','sim_config.vehicle_model',3);
% data_columns(end+1) = class_data_column({'Vehicle Description',''},'%s','sim_config.vehicle_description',3);
data_columns(end+1) = class_data_column({'Package',''},'%s','sim_config.package',1);
data_columns(end+1) = class_data_column({'Network Path',''},'%s','obj.sim_path',2);
data_columns(end+1) = class_data_column({'Filename',''},'%s','obj.output_file.name',2);
% data_columns(end+1) = class_data_column({'Unique Key','#'},'%s','sim_config.unique_key_num');
data_columns(end+1) = class_data_column({'Test Weight lbs','lbs'},prec0_str,'vehicle.ETW_lbs',1);
% data_columns(end+1) = class_data_column({'ETW Multiplier','#'},'%.2f','sim_config.ETW_multiplier',1);
data_columns(end+1) = class_data_column({'RL A lbf','lbf'},prec2_str,'vehicle.coastdown_target_A_lbf',1);
data_columns(end+1) = class_data_column({'RL B lbf/mph','lbf/mph'},prec4_str,'vehicle.coastdown_target_B_lbfpmph',1);
data_columns(end+1) = class_data_column({'RL C lbf/mph2','lbf/mph^2'},prec5_str,'vehicle.coastdown_target_C_lbfpmph2',1);
% data_columns(end+1) = class_data_column({'RL_ADJ A lbf','lbf'},prec2_str,'vehicle.coastdown_adjust_A_lbf',1);
% data_columns(end+1) = class_data_column({'RL_ADJ B lbf/mph','lbf/mph'},prec4_str,'vehicle.coastdown_adjust_B_lbfpmph',1);
% data_columns(end+1) = class_data_column({'RL_ADJ C lbf/mph2','lbf/mph^2'},prec5_str,'vehicle.coastdown_adjust_C_lbfpmph2',1);
data_columns(end+1) = class_data_column({'RL hp @ 50 mph','hp'},'%.2f','vehicle.calc_roadload_power_kW() * unit_convert.kW2hp',1);
% data_columns(end+1) = class_data_column({'RL Multiplier','#'},'%.2f','sim_config.roadload_multiplier',1);

if isfield(sim_config, 'performance_baseline')
    data_columns(end+1) = class_data_column({'Perf Baseline','#'},'%d','sim_config.performance_baseline');
end
if isfield(sim_config, 'performance_neutral')
    data_columns(end+1) = class_data_column({'Perf Neutral','#'},'%d','sim_config.performance_neutral', 2);
end
if isfield(sim_config, 'normalize_alphashift')
    data_columns(end+1) = class_data_column({'Shift Norm','#'},'%d','sim_config.normalize_alphashift', 2);
end
if isfield(sim_config, 'engine_transient_fuel_penalty')
    data_columns(end+1) = class_data_column({'Transient Penalty','#'},'%d','sim_config.engine_transient_fuel_penalty', 3);
end
if isfield(sim_config, 'weight_reduction_pct')
    data_columns(end+1) = class_data_column({'Weight Reduction %',''},'%f%%','sim_config.weight_reduction_pct', 2);
end
if isfield(sim_config, 'improve_aero_pct')
    data_columns(end+1) = class_data_column({'Aero Improvement %',''},'%f%%','sim_config.improve_aero_pct', 2);
end
if isfield(sim_config, 'improve_crr_pct')
    data_columns(end+1) = class_data_column({'Crr Improvement %',''},'%f%%','sim_config.improve_crr_pct', 2);
end
if isfield(sim_config, 'start_stop')
    data_columns(end+1) = class_data_column({'Start Stop',''},'%d','sim_config.start_stop', 2);
end
if isfield(sim_config, 'var_value')
    data_columns(end+1) = class_data_column({'Var Val',''},prec2_str,'sim_config.var_value', 2);
end
if isfield(sim_config, 'engine_deac_D_cyl_pct')
    data_columns(end+1) = class_data_column({'DEAC D Cyl.','%'},prec2_str,'sim_config.engine_deac_D_cyl_pct', 2);
end
if isfield(sim_config, 'engine_deac_C_cyl_pct')
    data_columns(end+1) = class_data_column({'DEAC C Cyl.','%'},prec2_str,'sim_config.engine_deac_C_cyl_pct', 2);
end
if isfield(sim_config, 'engine_deac_scale_pct')
    data_columns(end+1) = class_data_column({'DEAC Scale'  ,'%'},prec2_str,'sim_config.engine_deac_scale_pct', 2);
end
if isfield(sim_config, 'high_efficiency_alternator_regen')
    data_columns(end+1) = class_data_column({'High Eff. Alt. Regen',''},'%d','sim_config.high_efficiency_alternator_regen', 2);
end

%% Common Accessory Params
data_columns(end+1) = class_data_column({' ',' '}, separator, '0');
data_columns(end+1) = class_data_column({'Electric', 'Name'}, '%s', 'electric.name');
data_columns(end+1) = class_data_column({'Accessory', 'Name'}, '%s', 'accessories.name');
