%% propulsion battery results
%% battery results
if REVS.logging_config.has_package('REVS_log_accessory_battery')
    data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
    if isprop(result.phase.electric,'battery')
        data_columns(end+1) = class_data_column({'Initial Acc. Battery V','V'},prec1_str,  'result.phase.electric.battery.initial_OCV_V(1)',3);
        data_columns(end+1) = class_data_column({'Initial Acc. Battery SoC','%'},prec2_str,'result.phase.electric.battery.initial_SoC_norm(1) * 100',3);
        data_columns(end+1) = class_data_column({'Max Acc. Battery SoC','%'},  prec2_str,  'max(result.phase.electric.battery.max_SoC_norm) * 100',3);
        data_columns(end+1) = class_data_column({'Min Acc. Battery SoC','%'},  prec2_str,  'min(result.phase.electric.battery.min_SoC_norm) * 100',3);
        data_columns(end+1) = class_data_column({'Final Acc. Battery SoC','%'},prec2_str,  'result.phase.electric.battery.final_SoC_norm(end) * 100',3);
    else
        data_columns(end+1) = class_data_column({'Initial Acc. Battery V','V'},prec2_str,  'result.phase.electric.accessory_battery.initial_OCV_V(1)',3);
        data_columns(end+1) = class_data_column({'Initial Acc. Battery SoC','%'},prec2_str,'result.phase.electric.accessory_battery.initial_SoC_norm(1) * 100',3);
        data_columns(end+1) = class_data_column({'Max Acc. Battery SoC','%'},  prec2_str,  'max(result.phase.electric.accessory_battery.max_SoC_norm) * 100',3);
        data_columns(end+1) = class_data_column({'Min Acc. Battery SoC','%'},  prec2_str,  'min(result.phase.electric.accessory_battery.min_SoC_norm) * 100',3);
        data_columns(end+1) = class_data_column({'Final Acc. Battery SoC','%'},prec2_str,  'result.phase.electric.accessory_battery.final_SoC_norm(end) * 100',3);
    end
end

if REVS.logging_config.has_package('REVS_log_propulsion_battery') || REVS.logging_config.has_package('REVS_log_all')
    if ~isnan(model_data.propulsion_battery.terminal_voltage_V(1))
        data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
        data_columns(end+1) = class_data_column({'Initial Prop. Battery V','V'},prec2_str,  'model_data.propulsion_battery.terminal_voltage_V(1)',3);
        data_columns(end+1) = class_data_column({'Initial Prop. Battery SoC','%'},prec2_str,'model_data.propulsion_battery.state_of_charge_norm(1) * 100',1);
        data_columns(end+1) = class_data_column({'Final Prop. Battery SoC','%'},prec2_str, 'model_data.propulsion_battery.state_of_charge_norm(end) * 100',1);
        data_columns(end+1) = class_data_column({' ',' '},separator,'0',1);
        for p = 1:length(phase_names)
            if ~ismember(p, obj.output_restrict_phases)
                data_columns(end+1) = class_data_column({[phase_names{p} ' Prop. Battery Delta SoC'],'%'},prec2_str,['result.phase.electric.propulsion_battery.delta_SoC_norm(' num2str(p) ') * 100'],1);
            end
        end
        data_columns(end+1) = class_data_column({'Max Prop. Battery SoC','%'},  prec2_str, 'max(model_data.propulsion_battery.state_of_charge_norm) * 100',3);
        data_columns(end+1) = class_data_column({'Min Prop. Battery SoC','%'},  prec2_str, 'min(model_data.propulsion_battery.state_of_charge_norm) * 100',3);
    else % print spacers to keep headers aligned with 48V hybrids...
        data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
        data_columns(end+1) = class_data_column({'Initial Prop. Battery V','V'},separator,'0',3);
        data_columns(end+1) = class_data_column({'Initial Prop. Battery SoC','%'},separator,'0',3);
        for p = 1:length(phase_names)
            if ~ismember(p, obj.output_restrict_phases)
                data_columns(end+1) = class_data_column({[phase_names{p} ' Prop. Battery Delta SoC'],'%'},separator,'0',3);
            end
        end
        data_columns(end+1) = class_data_column({'Max Prop. Battery SoC','%'},separator,'0',3);
        data_columns(end+1) = class_data_column({'Min Prop. Battery SoC','%'},separator,'0',3);
        data_columns(end+1) = class_data_column({'Final Prop. Battery SoC','%'},separator,'0',3);
    end
end
