%% city/highway energy statistics

if REVS.logging_config.has_package('REVS_log_driveline_stats') || REVS.logging_config.has_package('REVS_log_all')
    
    for c = 1:length(result.weighted)
        
        cycle_name = result.weighted(c).cycle_name;
        
        if ~endsWith(cycle_name, 'PREP')
        
            data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Fuel Energy Rate J/m'],         'J/m'}, '%f',   ['result.weighted(',int2str(c),').fuel_Jpm'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Engine Energy Rate J/m'],       'J/m'}, '%f',   ['result.weighted(',int2str(c),').engine_Jpm'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Roadload Energy Rate J/m'],     'J/m'}, '%f',   ['result.weighted(',int2str(c),').roadload_Jpm'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Engine Efficiency %'],          '%'},   '%f',   ['result.weighted(',int2str(c),').engine_efficiency_norm * 100'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Transmission Efficiency %'],    '%'},   '%f',   ['result.weighted(',int2str(c),').transmission_efficiency_norm * 100'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Target Roadload Energy Rate J/m'],'J/m'},'%f',  ['result.weighted(',int2str(c),').unadjusted_roadload_Jpm'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Target Total Efficiency %'],    '%'},   '%f',   ['result.weighted(',int2str(c),').total_efficiency_norm * 100'],3);
            data_columns(end+1) = class_data_column({[cycle_name, ' Target Rel. Efficiency %'],     '%'},   '%f',   ['result.weighted(',int2str(c),').total_efficiency_norm / engine.max_efficiency_norm * 100'],3);
            if isproperty(result.weighted(c),'regen_efficiency_norm')
                data_columns(end+1) = class_data_column({[cycle_name, ' Regen. Efficiency %'],'%'},'%f',['result.weighted(',int2str(c),').regen_efficiency_norm  * 100'],3);
            end
        
        end
        
    end
        
        
%         
%     
%     if isfield(postproc_results,'weighted_results')
%     
%         if ~isempty(strfind(drive_cycle.name, 'FTP'))
%             data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
%             data_columns(end+1) = class_data_column({'FTP Fuel Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.ftp_fuel_Jpm',3);
%             data_columns(end+1) = class_data_column({'FTP Engine Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.ftp_crankshaft_Jpm',3);
%             data_columns(end+1) = class_data_column({'FTP Roadload Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.ftp_roadload_Jpm',3);
%             data_columns(end+1) = class_data_column({'FTP Engine Efficiency %','%'},'%f','postproc_results.weighted_results.ftp_engine_efficiency_norm * 100',3);
%             data_columns(end+1) = class_data_column({'FTP Transmission Efficiency %','%'},'%f','postproc_results.weighted_results.ftp_transmission_efficiency_norm * 100',3);
%             data_columns(end+1) = class_data_column({'FTP Target Roadload Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.ftp_unadjusted_roadload_Jpm',3);
%             data_columns(end+1) = class_data_column({'FTP Target Total Efficiency %','%'},'%f','postproc_results.weighted_results.ftp_fuel_efficiency_norm * 100',3);
%             data_columns(end+1) = class_data_column({'FTP Target Rel. Efficiency %','%'},'%f','postproc_results.weighted_results.ftp_fuel_efficiency_norm / engine.max_efficiency_norm * 100',3);
%             if isfield(postproc_results.weighted_results,'ftp_regen_eff_norm')
%                 data_columns(end+1) = class_data_column({'FTP Regen. Efficiency %','%'},'%f','postproc_results.weighted_results.ftp_regen_eff_norm  * 100',3);
%             end
%         end
% 
%         if ~isempty(strfind(drive_cycle.name, 'EPA_HWFET'))
%             data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
%             data_columns(end+1) = class_data_column({'HWFET Fuel Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.hwfet_fuel_Jpm',3);
%             data_columns(end+1) = class_data_column({'HWFET Engine Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.hwfet_crankshaft_Jpm',3);
%             data_columns(end+1) = class_data_column({'HWFET Roadload Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.hwfet_roadload_Jpm',3);
%             data_columns(end+1) = class_data_column({'HWFET Engine Efficiency %','%'},'%f','postproc_results.weighted_results.hwfet_engine_efficiency_norm * 100',3);
%             data_columns(end+1) = class_data_column({'HWFET Transmission Efficiency %','%'},'%f','postproc_results.weighted_results.hwfet_transmission_efficiency_norm * 100',3);
%             data_columns(end+1) = class_data_column({'HWFET Target Roadload Energy Rate J/m','J/m'},'%f','postproc_results.weighted_results.hwfet_unadjusted_roadload_Jpm',3);
%             data_columns(end+1) = class_data_column({'HWFET Target Total Efficiency %','%'},'%f','postproc_results.weighted_results.hwfet_fuel_efficiency_norm * 100',3);
%             data_columns(end+1) = class_data_column({'HWFET Target Rel. Efficiency %','%'},'%f','postproc_results.weighted_results.hwfet_fuel_efficiency_norm / engine.max_efficiency_norm * 100',3);
%             if isfield(postproc_results.weighted_results,'hwfet_regen_eff_norm')
%                 data_columns(end+1) = class_data_column({'HWFET Regen. Efficiency %','%'},'%f','postproc_results.weighted_results.hwfet_regen_eff_norm * 100',3);
%             end
%         end
% 
%         if ~isempty(strfind(drive_cycle.name, 'FTP')) && ~isempty(strfind(drive_cycle.name, 'EPA_HWFET'))
%             if isfield(postproc_results.weighted_results, 'combined_fuel_Jpm')
%                 data_columns(end+1) = class_data_column({' ',' '},'%s','separator',2);
%                 data_columns(end+1) = class_data_column({'Combined Fuel Energy Rate J/m','J/m'},prec3_str,'postproc_results.weighted_results.combined_fuel_Jpm',2);
%                 data_columns(end+1) = class_data_column({'Combined Engine Energy Rate J/m','J/m'},prec3_str,'postproc_results.weighted_results.combined_crankshaft_Jpm',2);
%                 data_columns(end+1) = class_data_column({'Combined Roadload Energy Rate J/m','J/m'},prec3_str,'postproc_results.weighted_results.combined_roadload_Jpm',2);
%                 data_columns(end+1) = class_data_column({'Combined Engine Efficiency %','%'},prec3_str,'postproc_results.weighted_results.combined_engine_efficiency_norm * 100',2);
%                 data_columns(end+1) = class_data_column({'Combined Transmission Efficiency %','%'},prec3_str,'postproc_results.weighted_results.combined_transmission_efficiency_norm * 100',2);
%                 data_columns(end+1) = class_data_column({'Combined Target Roadload Energy Rate J/m','J/m'},prec3_str,'postproc_results.weighted_results.combined_unadjusted_roadload_Jpm',2);
%                 data_columns(end+1) = class_data_column({'Combined Target Total Efficiency %','%'},prec3_str,'postproc_results.weighted_results.combined_fuel_efficiency_norm * 100',2);
%                 data_columns(end+1) = class_data_column({'Combined Target Rel. Efficiency %','%'},prec3_str,'postproc_results.weighted_results.combined_fuel_efficiency_norm / engine.max_efficiency_norm * 100',3);
%                 if isfield(postproc_results.weighted_results,'combined_regen_efficiency_norm')
%                     data_columns(end+1) = class_data_column({'Combined Regen. Efficiency %','%'},'%f','postproc_results.weighted_results.combined_regen_efficiency_norm * 100',3);
%                 end
%             end
%         end
%     
%     end

    if isfield(result.phase, 'engine')
        data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
        for p = 1:length(phase_names)
            if ~ismember(p, obj.output_restrict_phases)
                data_columns(end+1) = class_data_column({[phase_names{p} ' Max Engine Speed'],'RPM'},prec0_str,['result.phase.engine.max_crankshaft_spd_radps(' num2str(p) ') * unit_convert.radps2rpm'],3);

            end
        end
    end

    if isfield(postproc_results, 'regen_eff_norm')
        data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
        for p = 1:length(phase_names)
            if ~ismember(p, obj.output_restrict_phases)
                data_columns(end+1) = class_data_column({[phase_names{p} ' Regen Efficiency'],'%'},'%f',['result.phase.regen_efficiency_norm(' num2str(p) ') * 100 '],3);

            end
        end
    end
end