%% Engine Data
data_columns(end+1) = class_data_column({' ',' '},separator,'0');
data_columns(end+1) = class_data_column({'Engine','Filename'},'%s','engine.source_filename');
data_columns(end+1) = class_data_column({'Engine','Name'},'%s','engine.name');
% data_columns(end+1) = class_data_column({'Engine Vintage',''},'%s','strrep(mat2str(engine.matrix_vintage),''enum_matrix_vintage.'','''')',3);
% data_columns(end+1) = class_data_column({'Engine Scale %','%'},'%f','engine_scale_norm * 100',3);
% data_columns(end+1) = class_data_column({'Engine ES_PCT %','%'},'%f','engine_scale_norm/perf_scale * 100',3);
data_columns(end+1) = class_data_column({'Engine Displacement L','L'},prec3_str,'engine.displacement_L',2);
data_columns(end+1) = class_data_column({'Engine Cylinders','#'},'%f','engine.num_cylinders',2);
data_columns(end+1) = class_data_column({'Engine Max Power kW','kW'},'%.1f','engine.max_power_W/1000',2);
data_columns(end+1) = class_data_column({'Engine Max Torque Nm','Nm'},'%.1f','engine.max_torque_Nm',2);
data_columns(end+1) = class_data_column({'Engine Inertia kg-m2','kg-m^2'},prec4_str,'engine.inertia_kgm2',2);
data_columns(end+1) = class_data_column({'Engine Max Eff. %','%'},'%.1f','engine.max_efficiency_norm * 100',3);
data_columns(end+1) = class_data_column({'Engine Min BSFC g/kWh','g/kWh'},'%.1f','engine.min_bsfc_gpkWh',3);
data_columns(end+1) = class_data_column({'Engine Fuel ID','ID'},'%s','engine.fuel.id',3);
data_columns(end+1) = class_data_column({'Fast Fuel Torque Norm','#'},'%f','engine.fast_torque_fuel_adjust_norm',3);

data_columns(end+1) = class_data_column({'Engine Refuel Limit g/s','g/s'},'%f','engine.DFCO_refuel_multiplier_limit_gps',3);
data_columns(end+1) = class_data_column({'Engine Throttle/Power Time Const secs','secs'},'%.1f','engine.power_time_constant_secs',3);

data_columns(end+1) = class_data_column({'Engine Boost secs','secs'},'%.1f','engine.boost_time_constant_secs',3);

%% idle results
if REVS.logging_config.has_package('REVS_log_engine_idle') && ~isempty(strfind(drive_cycle.name, 'REVS_Performance'))
    % idle data:
    data_columns(end+1) = class_data_column({' ',' '},separator,'0',3);
    data_columns(end+1) = class_data_column({'Idle Speed RPM','RPM'},       '%f',   'result.phase.engine.initial_crankshaft_spd_radps(perf_start_phase) * unit_convert.radps2rpm',3);
    data_columns(end+1) = class_data_column({'Idle Gross Torque Nm','Nm'},  '%f',   'max(0, result.phase.engine.initial_gross_trq_Nm(perf_start_phase))',3);
    data_columns(end+1) = class_data_column({'Idle Gross Power kW','kW'},   '%f',   'result.phase.engine.initial_gross_trq_Nm(perf_start_phase) * result.phase.engine.initial_crankshaft_spd_radps(perf_start_phase) / 1000',3);
    data_columns(end+1) = class_data_column({'Idle Fuel Rate g/s','g/s'},   '%f',   'result.phase.engine.initial_fuel_rate_gps(perf_start_phase)',3);
    data_columns(end+1) = class_data_column({'Idle Efficiency %','%'},      '%f',   'result.phase.engine.initial_gross_trq_Nm(perf_start_phase) * result.phase.engine.initial_crankshaft_spd_radps(perf_start_phase) / 10 / result.phase.engine.initial_fuel_rate_gps(perf_start_phase) /  model_data.engine.fuel.energy_density_MJpkg',3);
    data_columns(end+1) = class_data_column({'Engine Fuel Energy Density MJ/kg','MJ/kg'},   '%f',   'engine.fuel.energy_density_MJpkg',3);
    data_columns(end+1) = class_data_column({'Vehicle Fuel Energy Density MJ/kg','MJ/kg'},  '%f',   'vehicle.fuel.energy_density_MJpkg',3);
end
