%% Transmission Data
data_columns(end+1) = class_data_column({' ',' '},separator,'0');
if transmission.type ~= enum_transmission_type.no_transmission
    data_columns(end+1) = class_data_column({'Transmission','Name'},'%s','transmission.name');
    data_columns(end+1) = class_data_column({'Transmission Vintage',''},'%s','strrep(mat2str(transmission.matrix_vintage),''enum_matrix_vintage.'','''')',3);
    data_columns(end+1) = class_data_column({'Transmission Torque Rating Nm','Nm'},'%.0f','transmission.rated_torque_Nm',2);
end

if isprop(transmission, 'gear')
    data_columns(end+1) = class_data_column({'Gear Count','#'},'%d','length(transmission.gear.ratio)-1',1);
else
    data_columns(end+1) = class_data_column({'Gear Count','#'},'%d','1',1);
end

if transmission.type == enum_transmission_type.CVT
    data_columns(end+1) = class_data_column({'Gear Ratios',''},'%s','mat2str(transmission.gear.ratio(end:-1:2),4)',1);
elseif isprop(transmission, 'gear')
    data_columns(end+1) = class_data_column({'Gear Ratios',''},'%s','mat2str(transmission.gear.ratio(2:end),4)',1);
end

data_columns(end+1) = class_data_column({'FDR','#'},prec3_str,'vehicle.drive_axle1.final_drive.gear_ratio',1); %  * fdr_space(fdr_cfg)
data_columns(end+1) = class_data_column({'AVG FDR Efficiency','%'},prec3_str,'mean(vehicle.drive_axle1.final_drive.efficiency_norm.table) * 100',1);

if ~vehicle.powertrain_type.is_bev && ~vehicle.powertrain_type.is_PS
    if transmission.type == enum_transmission_type.CVT
        data_columns(end+1) = class_data_column({'N/V','#'},'%.1f','unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * transmission.gear.ratio(2)',1);
        data_columns(end+1) = class_data_column({'N @ 60MPH','#'},'%.1f','unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * transmission.gear.ratio(2) * 60',1);
%         data_columns(end+1) = class_data_column({' ',' '},'NaN','0');
%         data_columns(end+1) = class_data_column({' ',' '},'NaN','0');
    else
        data_columns(end+1) = class_data_column({'N/V','#'},'%.1f','unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * transmission.gear.ratio(end)',1);
        data_columns(end+1) = class_data_column({'N @ 60MPH','#'},'%.1f','unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * transmission.gear.ratio(end) * 60',1);
        data_columns(end+1) = class_data_column({'Min Speed RPM','RPM'},'%.4f','transmission.gear_strategy.min_speed_radps(2) * unit_convert.radps2rpm',3);
        data_columns(end+1) = class_data_column({'Upshift Min Speed RPM','RPM'},'%.4f','transmission.gear_strategy.upshift_min_speed_radps(2) * unit_convert.radps2rpm',3);
    end
    if isprop(transmission, 'torque_converter') && ~isempty(transmission.torque_converter.speed_ratio)
        data_columns(end+1) = class_data_column({'K Factor RPM/sqrt(Nm)','RPM/sqrt(Nm)'},'%.1f','transmission.torque_converter.all_k_factors_rpmpsqrtNm(1)',2);
        data_columns(end+1) = class_data_column({'Torque Ratio','#'},'%.3f','transmission.torque_converter.all_torque_ratios(1)',2);
    else
%         data_columns(end+1) = class_data_column({' ',' '},'NaN','0');
%         data_columns(end+1) = class_data_column({' ',' '},'NaN','0');
    end
    
else
     data_columns(end+1) = class_data_column({'N/V','#'},'%.1f','unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio',1);
     data_columns(end+1) = class_data_column({'N @ 60MPH','#'},'%.1f','unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * vehicle.drive_axle1.final_drive.gear_ratio * 60',1);
end
