classdef ALPHAshift_delay < matlab.System
    % Untitled Add summary here
    %
    % This template includes the minimum set of functions required
    % to define a System object with discrete state.

    % Public, tunable properties
    properties
        upshift_delay
        downshift_delay
        upshift_commit
        downshift_commit
    end

    properties(DiscreteState)
        in_gear_timer;
        upshift_timer;
        downshift_timer;
        prev_shift_type;
        current_gear;
        prev_shift_reason;
    end

    % Pre-computed constants
    properties(Access = private)

    end

    methods(Access = protected)
        function setupImpl(obj)
            % Perform one-time calculations, such as computing constants
        
        end

        function [command_gear, shift_reason, in_gear_time, upshift_timer, downshift_timer] = outputImpl(obj, desired_gear, desired_shift_reason, dt)
        
            % set couputs
            in_gear_time = obj.in_gear_timer;    
            command_gear = obj.current_gear;
            shift_reason = obj.prev_shift_reason;
            upshift_timer = obj.upshift_timer;
            downshift_timer = obj.downshift_timer;
            
        end
        
        function updateImpl(obj, desired_gear, desired_shift_reason, dt)
            % Implement algorithm. Calculate y as a function of input u and
            % discrete states.
            
            obj.in_gear_timer = obj.in_gear_timer + dt;

            upshift_delay = obj.upshift_delay(obj.current_gear+1);
            downshift_delay = obj.downshift_delay(obj.current_gear+1);
            upshift_commit = obj.upshift_commit(obj.current_gear+1);
            downshift_commit = obj.downshift_commit(obj.current_gear+1);

            commit_satisfied = ( obj.prev_shift_type >= 0 && obj.in_gear_timer >= upshift_commit) || ...
                               ( obj.prev_shift_type <= 0 && obj.in_gear_timer >= downshift_commit);

            if desired_gear > obj.current_gear
                obj.upshift_timer = obj.upshift_timer + dt;
                obj.downshift_timer = 0;
            elseif desired_gear < obj.current_gear
                obj.upshift_timer = 0;
                obj.downshift_timer = obj.downshift_timer + dt;    
            else
                obj.upshift_timer = 0;
                obj.downshift_timer = 0;
            end
            
            
            if obj.current_gear <= 0
                obj.current_gear = desired_gear;
            elseif (obj.upshift_timer > upshift_delay && commit_satisfied) ||...
                  ( obj.upshift_timer > upshift_delay / 10 && desired_shift_reason == 4)
                obj.current_gear = desired_gear;
                obj.prev_shift_reason = desired_shift_reason;
                obj.in_gear_timer = 0;
                obj.prev_shift_type = 1;
            elseif ( obj.downshift_timer > downshift_delay && commit_satisfied) || ...
                   ( obj.downshift_timer > 0 && desired_shift_reason ~= 3)                
                obj.current_gear = desired_gear;
                obj.prev_shift_reason = desired_shift_reason;
                obj.in_gear_timer = 0;
                obj.prev_shift_type = -1;
            end

        end

        function resetImpl(obj)
            % Initialize / reset discrete-state properties
            obj.in_gear_timer = 0;
            obj.upshift_timer = 0;
            obj.downshift_timer = 0;
            obj.prev_shift_type = 0;
            obj.current_gear = 0;
            obj.prev_shift_reason = -1;
        end
                
    end
end
