classdef PS_control < matlab.System
    % Untitled Add summary here
    %
    % This template includes the minimum set of functions required
    % to define a System object with discrete state.
    
    % Public, tunable properties
    properties
        ring_sun_ratio                  % Ring:Sun Gear Ratio
        MG2_gear_ratio                  % MG2 Gear Ratio
        charge_sustain_upper_SoC_bound  % Charge Sustaining Upper SoC Bound
        charge_sustain_lower_SoC_bound  % Charge Sustaining Lower SoC Bound
        engine_cruise_activate_mps      % engine_cruise_activate_mps  % TODO: needs a better name
        engine_start_min_mps            % engine_start_min_mps  % TODO: needs a better name
        
    end
    
    properties(DiscreteState)
        engine_on_state
        engine_start_time
        charge_sustain_state
        
    end
    
    % Pre-computed constants
    properties(Access = private)
        
    end
    
    methods(Access = protected)
        function setupImpl(obj)
            % Perform one-time calculations, such as computing constants
            
        end
                
        function [ ...
                engine_on_off_state, ...
                engine_desired_power_W, ...
                engine_desired_torque_Nm, ...               
                engine_target_speed_radps, ...
                MG2_torque_request_Nm, ...
                power_limited_MG2_max_regen_torque_Nm, ...
                power_limited_MG2_max_motor_torque_Nm, ...
                MG2_regen_torque_limit_Nm, ...
                MG2_motor_torque_limit_Nm, ...
                charge_sustain_state, ...
                driveline_power_request_kW] ...
                = ...
                stepImpl(obj,...
                time, ...
                start_stop_allowed_bool, ...
                engine_warmup_condition,...
                tire_radius_m, ...
                final_drive_ratio, ...
                vehicle_speed_mps, ...
                driveline_wheel_torque_request_Nm,...
                engine_speed_radps, ...
                battery_max_charge_power_W, ...
                battery_max_discharge_power_W, ...
                MG1_speed_radps, ...
                MG2_speed_radps, ...
                MG2_pos_torque_limit_Nm, ...
                MG2_neg_torque_limit_Nm, ...
                engine_max_torque_Nm, ...
                motor_soc_derate_norm, ...
                regen_torque_limit_Nm, ...
                regen_soc_derate_norm, ...
                regen_vspeed_derate_norm, ...
                battery_soc_norm, ...
                engine_min_bsfc_speed_radps, ...
                MG1_PID_torque_Nm, ...
                battery_charge_request_W,...
                engine_start_power_kW,...
                engine_stop_power_kW)
            
           
            soc_cs_low = obj.charge_sustain_lower_SoC_bound;
            soc_cs_low_lb = soc_cs_low - 0.015;
            soc_cs_high = obj.charge_sustain_upper_SoC_bound;
            soc_cs_high_ub = 0.80;%max(max(soc_cs_high));%,0.75),0.78);
                        
            MG1_power_W = MG1_PID_torque_Nm * MG1_speed_radps;
            
            %:: probably a better name for these
            power_limited_MG2_max_regen_torque_Nm = (0.95 * battery_max_charge_power_W    - 1.1 * max(0, -MG1_power_W)) ./ max(0.1, MG2_speed_radps);
            power_limited_MG2_max_motor_torque_Nm = (0.95 * battery_max_discharge_power_W - 1.1 * max(0,  MG1_power_W)) ./ max(0.1, MG2_speed_radps);
            
            MG2_regen_max_torque_Nm = min( -MG2_neg_torque_limit_Nm, -regen_torque_limit_Nm);
            
            MG2_regen_torque_limit_Nm = min(regen_vspeed_derate_norm, regen_soc_derate_norm) * min(power_limited_MG2_max_regen_torque_Nm, MG2_regen_max_torque_Nm);
            MG2_motor_torque_limit_Nm = motor_soc_derate_norm * min(power_limited_MG2_max_motor_torque_Nm, MG2_pos_torque_limit_Nm);
            MG2_motor_power_limit_kW  = MG2_motor_torque_limit_Nm * MG2_speed_radps / 1000; 
            
            driveline_power_request_kW = driveline_wheel_torque_request_Nm * vehicle_speed_mps / tire_radius_m / 1000;
            
            
            inputs_valid = (time > 0.01);
            
            % initial charge_sustain_state = 0 (battery_soc_norm < soc_cs_low)
            if inputs_valid && (obj.charge_sustain_state == 0) && (battery_soc_norm < soc_cs_low) ...
                    || ((battery_soc_norm < soc_cs_high) && (time < 0.1))
                % if inputs_valid && (obj.charge_sustain_state == 0) && (battery_soc_norm < 0.35) || ((battery_soc_norm < 0.415) && (time < 0.1))
                obj.charge_sustain_state = 1;
            end
            
                        
            MG2_torque_request_Nm = ( (driveline_wheel_torque_request_Nm / final_drive_ratio) - (-MG1_PID_torque_Nm * obj.ring_sun_ratio) )  / obj.MG2_gear_ratio;
            MG2_torque_request_Nm = min( MG2_torque_request_Nm, MG2_motor_torque_limit_Nm);
            MG2_torque_request_Nm = max( MG2_torque_request_Nm, -MG2_regen_torque_limit_Nm);
            
            if obj.engine_on_state == 0 % obj.engine_on_off_state == off
                engine_desired_torque_Nm  = 0;
                engine_target_speed_radps = 0;
                
                engine_desired_power_W = 0;
                
                if inputs_valid && ((driveline_power_request_kW > engine_start_power_kW && vehicle_speed_mps > obj.engine_start_min_mps) ...
                        || (vehicle_speed_mps > 100 + 0.5) ... % ???
                        || (battery_soc_norm <= soc_cs_low_lb))
                    obj.engine_on_state = 1;
                    obj.engine_start_time = time;
                end
                
            else % obj.engine_on_off_state == on
                
                engine_target_speed_radps = max(1, engine_min_bsfc_speed_radps);
                               
                if (driveline_wheel_torque_request_Nm > 0) && obj.charge_sustain_state
                    engine_desired_power_W = (driveline_power_request_kW*1000) + (battery_charge_request_W);
                    engine_desired_torque_Nm = 1 * max(0, min(engine_max_torque_Nm, engine_desired_power_W / max(1, engine_target_speed_radps)));
                else
                    engine_desired_power_W = max(0, battery_charge_request_W);
                    engine_desired_torque_Nm = 1 * max(0, min(engine_max_torque_Nm, battery_charge_request_W / max(1, engine_target_speed_radps)));
                end
                
                % :: Some intermediate variables might clarify this logic & why time
                if (battery_soc_norm >= soc_cs_high_ub &&  MG2_motor_power_limit_kW >= driveline_power_request_kW) || ...                         
                        ( (start_stop_allowed_bool || ( (time > 100) && (driveline_power_request_kW < -25)) ) ...
                        && ( vehicle_speed_mps < obj.engine_cruise_activate_mps ) ...
                        && ( battery_soc_norm > soc_cs_low ) ...
                        && ( (vehicle_speed_mps < 1) || (driveline_power_request_kW <= engine_stop_power_kW) ) )
                    
                    obj.engine_on_state = 0;
                    
                end
                
                
            end
            
            % ::What is this?
            if ~start_stop_allowed_bool && ~engine_warmup_condition
                
                if time < 73
                    engine_desired_torque_Nm = 15;
                end
                
                if engine_target_speed_radps < 137 && time < 124
                    engine_target_speed_radps = 137;
                end
            end
            
            charge_sustain_state = obj.charge_sustain_state;
            engine_on_off_state = obj.engine_on_state;
        end
        
        
        function resetImpl(obj)
            % Initialize / reset discrete-state properties
            obj.engine_on_state = 0;
            obj.engine_start_time = 0;
            obj.charge_sustain_state = 0; 
        end
    end
end
