/*
 * sfuntmpl_basic.c: Basic 'C' template for a level 2 S-function.
 *
 * Copyright 1990-2013 The MathWorks, Inc.
 */


/*
 * You must specify the S_FUNCTION_NAME as the name of your S-function
 * (i.e. replace sfuntmpl_basic with the name of your S-function).
 */

#define S_FUNCTION_NAME  dynamic_bus_select_idx
#define S_FUNCTION_LEVEL 2


// Make work for MingW & Windows SDK (Visual C++)
// #ifdef _MSC_VER
// 	#define strtok_r(a,b,c) strtok_s(a,b,c)
// #endif


/*
 * Need to include simstruc.h for the definition of the SimStruct and
 * its associated macro definitions.
 */
#include "simstruc.h"



/* Error handling
 * --------------
 *
 * You should use the following technique to report errors encountered within
 * an S-function:
 *
 *       ssSetErrorStatus(S,"Error encountered due to ...");
 *       return;
 *
 * Note that the 2nd argument to ssSetErrorStatus must be persistent memory.
 * It cannot be a local variable. For example the following will cause
 * unpredictable errors:
 *
 *      mdlOutputs()
 *      {
 *         char msg[256];         {ILLEGAL: to fix use "static char msg[256];"}
 *         sprintf(msg,"Error due to %s", string);
 *         ssSetErrorStatus(S,msg);
 *         return;
 *      }
 *
 */

/*====================*
 * S-function methods *
 *====================*/

/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *    The sizes information is used by Simulink to determine the S-function
 *    block's characteristics (number of inputs, outputs, states, etc.).
 */
static void mdlInitializeSizes(SimStruct *S)
{

	unsigned int output_size;
	const mxArray*	mx_output_size;
// 	char		*bus_sig_list;
// 	char		*bus_sig;
// 	int_T		in_port_size =0;
    
	ssSetNumSFcnParams(S, 3);  /* Number of expected parameters */
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        /* Return if number of expected != number of actual parameters */
        return;
    }

	ssSetSFcnParamTunable(S, 0, SS_PRM_TUNABLE);
	ssSetSFcnParamTunable(S, 1, SS_PRM_NOT_TUNABLE);
	ssSetSFcnParamTunable(S, 2, SS_PRM_NOT_TUNABLE);
// 	ssSetSFcnParamTunable(S, 3, SS_PRM_NOT_TUNABLE);

	
    ssSetNumContStates(S, 0);
    ssSetNumDiscStates(S, 0);

	if (!ssSetNumInputPorts(S, 0)) return;
// 	bus_sig_list = mxArrayToString(ssGetSFcnParam(S, 1) );
// 	
// 	ssPrintf("BUS LIST: %s \n", bus_sig_list);
// 	bus_sig = strtok_r(bus_sig_list," ,", &bus_sig_list);
// 	while( bus_sig != NULL ) 
// 	{		
// 		ssPrintf("BUS: %d %s \n", in_port_size, bus_sig);
// 		in_port_size++;   
// 		bus_sig = strtok_r (bus_sig_list, " ,", &bus_sig_list);
// 	}  
// 	
// 	ssSetInputPortWidth(S, 0, DYNAMICALLY_SIZED );
// // 		ssSetInputPortWidth(S, 0, mxGetScalar(ssGetSFcnParam(S, 3)) );
//     ssSetInputPortRequiredContiguous(S, 0, true); /*direct input signal access*/
	
    /*
     * Set direct feedthrough flag (1=yes, 0=no).
     * A port has direct feedthrough if the input is used in either
     * the mdlOutputs or mdlGetTimeOfNextVarHit functions.
     */
//     ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S, 1)) return;
    
	ssSetOutputPortWidth(S, 0, mxGetScalar(ssGetSFcnParam(S, 2)) ) ;

    ssSetNumSampleTimes(S, 1);
    ssSetNumRWork(S, 0);
    ssSetNumIWork(S, mxGetScalar(ssGetSFcnParam(S, 2)));
    ssSetNumPWork(S, 0);
    ssSetNumModes(S, 0);
    ssSetNumNonsampledZCs(S, 0);

    /* Specify the sim state compliance to be same as a built-in block */
    ssSetSimStateCompliance(S, USE_DEFAULT_SIM_STATE);

    ssSetOptions(S, SS_OPTION_USE_TLC_WITH_ACCELERATOR );
// 	    ssSetOptions(S, SS_OPTION_USE_TLC_WITH_ACCELERATOR | SS_OPTION_EXCEPTION_FREE_CODE);
}


// #if defined(MATLAB_MEX_FILE)
// # define MDL_SET_INPUT_PORT_WIDTH
//   static void mdlSetInputPortWidth(SimStruct *S, int_T port, int_T inputPortWidth)
//   {
//       ssSetInputPortWidth(S,port,inputPortWidth);
//   }
// 
//    # define MDL_SET_OUTPUT_PORT_WIDTH
//   static void mdlSetOutputPortWidth(SimStruct *S, int_T port, int_T outputPortWidth)
//   {         
//       ssSetOutputPortWidth(S,port,outputPortWidth);
//   }
//   
// # define MDL_SET_DEFAULT_PORT_DIMENSION_INFO
//   /* Function: mdlSetDefaultPortDimensionInfo ===========================================
//    * Abstract:
//    *   In case no ports were specified, the default is an input port of width 2
//    *   and an output port of width 1.
//    */
//   static void mdlSetDefaultPortDimensionInfo(SimStruct        *S)
//   {
//       ssSetInputPortWidth(S, 0, mxGetScalar(ssGetSFcnParam(S, 3)));
//   }
// #endif



/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    This function is used to specify the sample time(s) for your
 *    S-function. You must register the same number of sample times as
 *    specified in ssSetNumSampleTimes.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
//     ssSetSampleTime(S, 0, CONTINUOUS_SAMPLE_TIME);
	ssSetSampleTime(S, 0, INHERITED_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);

}

#define MDL_SET_WORK_WIDTHS   /* Change to #undef to remove function */
#if defined(MDL_SET_WORK_WIDTHS) && defined(MATLAB_MEX_FILE)
/* Function: mdlSetWorkWidths ===============================================
 * Abstract:
 *      Set up run-time parameters.
 */
static void mdlSetWorkWidths(SimStruct *S)
{
    const char_T    *rtParamNames[] = {"Signals"};
    ssRegAllTunableParamsAsRunTimeParams(S, rtParamNames);
}
#endif /* MDL_SET_WORK_WIDTHS */


#define MDL_PROCESS_PARAMETERS   /* Change to #undef to remove function */
#if defined(MDL_PROCESS_PARAMETERS) && defined(MATLAB_MEX_FILE)
/* Function: mdlProcessParameters ===========================================
 * Abstract:
 *      Update run-time parameters.
 */
static void mdlProcessParameters(SimStruct *S)
{
    /* Update Run-Time parameters */
    ssUpdateAllTunableParamsAsRunTimeParams(S);
}
#endif /* MDL_PROCESS_PARAMETERS */


#define MDL_INITIALIZE_CONDITIONS   /* Change to #undef to remove function */
#if defined(MDL_INITIALIZE_CONDITIONS)
  /* Function: mdlInitializeConditions ========================================
   * Abstract:
   *    In this function, you should initialize the continuous and discrete
   *    states for your S-function block.  The initial states are placed
   *    in the state vector, ssGetContStates(S) or ssGetRealDiscStates(S).
   *    You can also perform any other initialization activities that your
   *    S-function may require. Note, this routine will be called at the
   *    start of simulation and if it is present in an enabled subsystem
   *    configured to reset states, it will be call when the enabled subsystem
   *    restarts execution to reset the states.
   */
  static void mdlInitializeConditions(SimStruct *S)
  {
	  
	int_T		max_select_sigs = mxGetScalar(ssGetSFcnParam(S, 2));
	int_T		i, j;
	real_T		*y = ssGetOutputPortSignal(S,0);
	char		*select_sig_list;
	char		*bus_sig_list;
	char		*select_sig;
	char		*bus_sig;

    bus_sig_list = mxArrayToString(ssGetSFcnParam(S, 1) );

// 	ssPrintf("BUS LIST: %s \n",  bus_sig_list);

	
	
	select_sig_list = (char*) mxGetPr(ssGetSFcnParam(S, 0) );
	select_sig = strtok_r(select_sig_list," ,", &select_sig_list);
	
// 	ssPrintf("SELECT LIST: %s \n",  select_sig_list);


	
	for( i = 0 ; i < max_select_sigs ; i++ ) // (select_sig != NULL && i < max_select_sigs)
	{	
        ssSetIWorkValue(S, i, -1);
       		
		if( select_sig != NULL ) 
        {
            
// 			ssPrintf("SELECT: %d %s \n", i, select_sig);
			
            bus_sig_list = mxArrayToString(ssGetSFcnParam(S, 1) );

			j = 0;
            while( ((bus_sig = strtok_r(bus_sig_list, " ,", &bus_sig_list))) && ( strcmp( select_sig, bus_sig + strlen(bus_sig) - strlen(select_sig) ) != 0 ))
				j++;

			if( bus_sig != NULL)
				ssSetIWorkValue(S, i, j);
		
			// Get next signal
			select_sig = strtok_r (select_sig_list, " ,", &select_sig_list);
        
		}     

	}
	
  }
#endif /* MDL_INITIALIZE_CONDITIONS */



#define MDL_START  /* Change to #undef to remove function */
#if defined(MDL_START) 
  /* Function: mdlStart =======================================================
   * Abstract:
   *    This function is called once at start of model execution. If you
   *    have states that should be initialized once, this is the place
   *    to do it.
   */
  static void mdlStart(SimStruct *S)
  {
  }
#endif /*  MDL_START */



/* Function: mdlOutputs =======================================================
 * Abstract:
 *    In this function, you compute the outputs of your S-function
 *    block.
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
    const real_T *u = (const real_T*) ssGetInputPortSignal(S,0);
    real_T       *y = ssGetOutputPortSignal(S,0);
	int_T		*m = ssGetIWork(S);
	int_T		i;
	
	for( i = 0; i < ssGetOutputPortWidth( S, 0) ; i++ )
    {
        if( m[i] >= 0 )
            y[i] = m[i];
    }
	
}



#define MDL_UPDATE  /* Change to #undef to remove function */
#if defined(MDL_UPDATE)
  /* Function: mdlUpdate ======================================================
   * Abstract:
   *    This function is called once for every major integration time step.
   *    Discrete states are typically updated here, but this function is useful
   *    for performing any tasks that should only take place once per
   *    integration step.
   */
  static void mdlUpdate(SimStruct *S, int_T tid)
  {
  }
#endif /* MDL_UPDATE */



#define MDL_DERIVATIVES  /* Change to #undef to remove function */
#if defined(MDL_DERIVATIVES)
  /* Function: mdlDerivatives =================================================
   * Abstract:
   *    In this function, you compute the S-function block's derivatives.
   *    The derivatives are placed in the derivative vector, ssGetdX(S).
   */
  static void mdlDerivatives(SimStruct *S)
  {
  }
#endif /* MDL_DERIVATIVES */



/* Function: mdlTerminate =====================================================
 * Abstract:
 *    In this function, you should perform any actions that are necessary
 *    at the termination of a simulation.  For example, if memory was
 *    allocated in mdlStart, this is the place to free it.
 */
static void mdlTerminate(SimStruct *S)
{
}


#if defined(MATLAB_MEX_FILE)
#define MDL_RTW
/* Function: mdlRTW ===========================================================
 * Abstract:
 *      Write out the signs parameter setting for this block.
 */
static void mdlRTW(SimStruct *S)
{

    /*
     * Write out the "SignsStr" param settings.  An example of its form for
     *   '++-' is:
     *
     *      ["+", "+", "-"], so to be conservative we will consider the length
     *                       of the string to be:
     *      
     *          nu = number of signs
     *
     * length = (nu * 5) +  %quote,sign,quote,comma,space
     *          2           %brackets
     *          1           %NULL terminator ('\0')
     */
 
		char* bus_sig_list;
		char* select_sig_list;
		

		select_sig_list = (char*) mxGetPr(ssGetSFcnParam(S, 0) );

		bus_sig_list = mxArrayToString(ssGetSFcnParam(S, 1) );

		
		
		if (!ssWriteRTWParamSettings(S, 1, SSWRITE_VALUE_QSTR, "BusSignals",bus_sig_list)) 
			return;
		
// 		if (!ssWriteRTWStrParam(S,"SelectSignals",select_sig_list)) 
// 			return;
// 		
		
		 if (!ssWriteRTWWorkVect(S, "IWork", 1,"Mapping", ssGetNumIWork(S))) 
			return;

}
#endif /* MDL_RTW */



/*=============================*
 * Required S-function trailer *
 *=============================*/

#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
