function logging_enable(block)

  setup(block);
  
function setup(block)
  
  block.NumDialogPrms  = 4;
    
  %% Register number of input and output ports
  block.NumInputPorts  = 0;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
   
  block.OutputPort(1).Dimensions      = 1;
  block.OutputPort(1).DatatypeID      = 0; %8 = Boolean
  block.OutputPort(1).SamplingMode = 'Sample';
   
  %% Set block sample time to inherited
  block.SampleTimes = [-1 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
   block.RegBlockMethod('Start',                  @Start);  
  block.RegBlockMethod('Outputs',                 @Output);  
  
function DoPostPropSetup(block)

  %% Setup Dwork
  block.NumDworks = 1;
  block.Dwork(1).Name = 'x0'; 
  block.Dwork(1).Dimensions      = 1;
  block.Dwork(1).DatatypeID      = 0; %8 = Boolean
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

%endfunction

function Start(block)

  %% Initialize Dwork
  
  hit = false;
  idx = numel( block.DialogPrm(3).Data);
  
  while ~hit && idx > 0
     hit = hit || ~isempty(  regexpi( block.DialogPrm(4).Data, block.DialogPrm(3).Data{idx}, 'once'));
     idx = idx - 1;
  end    
   
  block.Dwork(1).Data = double(hit || ( block.DialogPrm(2).Data >= block.DialogPrm(1).Data ));
  
function Output(block)

  block.OutputPort(1).Data = block.Dwork(1).Data;
  