classdef tableshift2 < matlab.System
    % Untitled Add summary here
    %
    % This template includes the minimum set of functions required
    % to define a System object with discrete state.

    % Public, tunable properties
    properties
        upshift_delay
        downshift_delay
        upshift_skip_load
        downshift_skip_load
        upshift_commit
    end

    properties(DiscreteState)
        post_upshift_timer;
        upshift_timer;
        downshift_timer;
        current_gear;
    end

    % Pre-computed constants
    properties(Access = private)

    end

    methods(Access = protected)
        function setupImpl(obj)
            % Perform one-time calculations, such as computing constants
        end

        function [command_gear, upshift_timer, downshift_timer] = outputImpl(obj, speed, load, upshift_speed, downshift_speed,  dt)
        
            % set couputs
            command_gear = obj.current_gear;
            upshift_timer = obj.upshift_timer;
            downshift_timer = obj.downshift_timer;
            
        end
        
        function updateImpl(obj, speed, load, upshift_speed, downshift_speed,  dt)
            obj.post_upshift_timer = obj.in_gear_timer + dt;
            
            obj.upshift_timer = (speed > upshift_speed ) * ( obj.upshift_timer + dt);
            
            obj.downshift_timer = (speed < downshift_speed ) * ( obj.downshift_timer + dt);
            
            upshift_delay = obj.upshift_delay(obj.current_gear+1);
            downshift_delay = obj.downshift_delay(obj.current_gear+1);
            upshift_skip_load = obj.upshift_skip_load( obj.current_gear +1 );
            downshift_skip_load = obj.downshift_skip_load( obj.current_gear +1 );
            
            if obj.upshift_timer > upshift_delay && load > upshift_skip_load
                obj.current_gear = obj.current_gear + 2;
                obj.post_upshift_timer = 0;
                obj.upshift_timer = 0;
                
                
            elseif  obj.upshift_timer > upshift_delay
                obj.current_gear = obj.current_gear + 1;
                obj.post_upshift_timer = 0;
                obj.upshift_timer = 0;
                
            elseif obj.post_upshift_timer <= obj.upshift_commit
                % Block Downshifts
            
            elseif obj.downshift_timer > downshift_delay && load > downshift_skip_load
                obj.current_gear = min(1, obj.current_gear - 2);
                obj.downshift_timer = 0;
                
            elseif obj.downshift_timer > downshift_delay
                obj.current_gear = min(1, obj.current_gear - 1);
                obj.downshift_timer = 0;
                
            end
        end
        


        function resetImpl(obj)
            % Initialize / reset discrete-state properties
            obj.post_upshift_timer = 0;
            obj.upshift_timer = 0;
            obj.downshift_timer = 0;
            
            obj.current_gear = 0;
        end
    end
end
