%% drive motor
if vehicle.powertrain_type.is_bev
    
    model_data.emachine.speed_radps  = datalog.electric.drive_motor.output_spd_radps;
    model_data.emachine.torque_Nm    = datalog.electric.drive_motor.output_trq_Nm;
    model_data.emachine.current_A    = datalog.electric.drive_motor.input_curr_A;
    model_data.emachine.voltage_V    = datalog.electric.drive_motor.input_volt_V;
    
    postproc_results.regen_eff_norm = -result.phase.electric.drive_motor.regen_neg_kJ./result.phase.vehicle.decel_KE_kJ;

end

if vehicle.powertrain_type.is_hybrid

    if vehicle.powertrain_type.is_P0 && ~vehicle.powertrain_type.is_P2
        
        model_data.emachine.speed_radps  = datalog.electric.P0_MG.output_spd_radps;
        model_data.emachine.torque_Nm    = datalog.electric.P0_MG.output_trq_Nm;
        model_data.emachine.current_A    = datalog.electric.P0_MG.input_curr_A;
        model_data.emachine.voltage_V    = datalog.electric.P0_MG.input_volt_V;

        postproc_results.regen_eff_norm = -result.phase.electric.P0_MG.regen_neg_kJ./result.phase.vehicle.decel_KE_kJ;
    
    end

    if vehicle.powertrain_type.is_P0 && vehicle.powertrain_type.is_P2
        
        model_data.MG1.speed_radps  = datalog.electric.P0_MG.output_spd_radps;
        model_data.MG1.torque_Nm    = datalog.electric.P0_MG.output_trq_Nm;
        model_data.MG1.current_A    = datalog.electric.P0_MG.input_curr_A;
        model_data.MG1.voltage_V    = datalog.electric.P0_MG.input_volt_V;
        
        model_data.MG1.efficiency_norm = min(abs(model_data.MG1.mechanical_power_kW), abs(model_data.MG1.electrical_power_kW)) ./ max(abs(model_data.MG1.mechanical_power_kW), abs(model_data.MG1.electrical_power_kW));
        
%         postproc_results.regen_eff_norm = -result.phase.electric.P0_MG.regen_neg_kJ./result.phase.vehicle.decel_KE_kJ;    
    end
    
    
    if vehicle.powertrain_type.is_P2

        model_data.emachine.speed_radps  = datalog.transmission.P2_MG.output_spd_radps;
        model_data.emachine.torque_Nm    = datalog.transmission.P2_MG.output_trq_Nm;
        model_data.emachine.current_A    = datalog.transmission.P2_MG.input_curr_A;
        model_data.emachine.voltage_V    = datalog.transmission.P2_MG.input_volt_V; 

        postproc_results.regen_eff_norm = -result.phase.transmission.P2_MG.regen_neg_kJ./result.phase.vehicle.decel_KE_kJ;

    end
    
    if vehicle.powertrain_type == enum_powertrain_type.hybrid_powersplit
        
        postproc_results.regen_eff_norm = -result.phase.transmission.MG2.regen_neg_kJ./result.phase.vehicle.decel_KE_kJ; %Need to check if MG1 needs to be added
        model_data.emachine.speed_radps  = datalog.transmission.MG1.output_spd_radps;
        model_data.emachine.torque_Nm    = datalog.transmission.MG1.output_trq_Nm;
        model_data.emachine.current_A    = datalog.transmission.MG1.input_curr_A;
        model_data.emachine.voltage_V    = datalog.transmission.MG1.input_volt_V;

        model_data.MG2.speed_radps = datalog.transmission.MG2.output_spd_radps;
        model_data.MG2.torque_Nm   = datalog.transmission.MG2.output_trq_Nm;
        model_data.MG2.current_A   = datalog.transmission.MG2.input_curr_A;
        model_data.MG2.voltage_V   = datalog.transmission.MG2.input_volt_V;        

        model_data.MG2.efficiency_norm = min(abs(model_data.MG2.mechanical_power_kW), abs(model_data.MG2.electrical_power_kW)) ./ max(abs(model_data.MG2.mechanical_power_kW), abs(model_data.MG2.electrical_power_kW));

    end
end

model_data.emachine.efficiency_norm = min(abs(model_data.emachine.mechanical_power_kW), abs(model_data.emachine.electrical_power_kW)) ./ max(abs(model_data.emachine.mechanical_power_kW), abs(model_data.emachine.electrical_power_kW));

% if isprop(model_data.controls,'regen_flag')
%     
% %     postproc_results.regen_eff = REVS_calc_regen_eff_stats( datalog.time, datalog , model_data );
%     
% end
