
if ~vehicle.powertrain_type.has_engine
    return
end


model_data.vehicle.fuel.mass_g               = datalog.engine.fuel_consumed_g;

model_data.engine.speed_radps				 = datalog.engine.crankshaft_spd_radps;

if vehicle.powertrain_type.is_hybrid
    % "crankshaft torque" includes upstream torques... like from a P0
    % starter-generater... so it's confusing for hybrids
    % model_data.engine.crankshaft_torque_Nm = datalog.engine.crankshaft_trq_Nm;
    
    model_data.engine.crankshaft_torque_Nm = datalog.engine.load_Nm;
else
    model_data.engine.crankshaft_torque_Nm = datalog.engine.crankshaft_trq_Nm;
end

model_data.engine.load_at_current_speed_norm = datalog.engine.load_norm;

model_data.engine.fuel.density_kgpL_15C      = engine.fuel.density_kgpL_15C;
model_data.engine.fuel.energy_density_MJpkg  = engine.fuel.energy_density_MJpkg;
model_data.engine.fuel.flow_rate_gps         = datalog.engine.fuel_rate_gps;

if isprop(datalog.engine,'gross_trq_Nm')
    model_data.engine.gross_torque_Nm            = datalog.engine.gross_trq_Nm;
end