
model_data.transmission.type = transmission.type;

if model_data.transmission.type ~= enum_transmission_type.no_transmission
    
    if model_data.transmission.type ~= enum_transmission_type.CVT
        if isprop(datalog.transmission,'gearbox')
            model_data.transmission.current_gear_number          = datalog.transmission.gearbox.current_gear;
        else
            model_data.transmission.current_gear_number          = datalog.transmission.current_gear;
        end
        model_data.transmission.commanded_gear_number        = datalog.transmission.selected_gear_num;
    end
    
    if model_data.transmission.type == enum_transmission_type.DCT
        model_data.transmission.gearbox_input_torque_Nm      = datalog.transmission.gearbox1.input_trq_Nm + datalog.transmission.gearbox2.input_trq_Nm;
    else
        model_data.transmission.gearbox_input_torque_Nm      = datalog.transmission.gearbox.input_trq_Nm;
    end
    
    if isprop(datalog,'transmission') && isprop(datalog.transmission,'clutch_engage_norm')
        model_data.transmission.launch_device_lockup_norm    = datalog.transmission.clutch_engage_norm;
    elseif model_data.transmission.type == enum_transmission_type.automatic && isprop(datalog, 'torque_converter_clutch_command_norm')
        model_data.transmission.launch_device_lockup_norm    = datalog.transmission.torque_converter_clutch_command_norm; % datalog.torque_converter.tcc_engage_norm;
    elseif model_data.transmission.type == enum_transmission_type.CVT && isprop(datalog, 'torque_converter_clutch_command_norm')
        model_data.transmission.launch_device_lockup_norm    = datalog.transmission.torque_converter_clutch_command_norm; % datalog.torque_converter.tcc_engage_norm;
        % other trans types here
    end
    
    if model_data.transmission.type == enum_transmission_type.CVT
        model_data.transmission.current_CVT_ratio        = min(max(transmission.gear.ratio), datalog.transmission.gearbox.actual_ratio .* (datalog.transmission.gearbox.engage_norm > 0));
    elseif model_data.transmission.type == enum_transmission_type.DCT
        odd_pts     = datalog.transmission.clutch1_command_norm ~= 0;
        even_pts    = datalog.transmission.clutch2_command_norm ~= 0;
        
        temp.transmission_current_gear_ratio                    = zeros(size(model_data.time));
        temp.transmission_current_gear_ratio(odd_pts)           = datalog.transmission.gearbox1.actual_ratio(odd_pts);
        temp.transmission_current_gear_ratio(even_pts)          = datalog.transmission.gearbox2.actual_ratio(even_pts);
        model_data.transmission.current_gear_ratio               = temp.transmission_current_gear_ratio;
        
        temp.transmission.gearbox_input_speed_radps             = zeros(size(model_data.time));
        temp.transmission.gearbox_input_speed_radps(odd_pts)    = datalog.transmission.gearbox1.input_spd_radps(odd_pts);
        temp.transmission.gearbox_input_speed_radps(even_pts)   = datalog.transmission.gearbox2.input_spd_radps(even_pts);
        model_data.transmission.gearbox_input_speed_radps        = temp.transmission.gearbox_input_speed_radps;
    else
        model_data.transmission.current_gear_ratio       = datalog.transmission.gearbox.actual_ratio;
    end
    
    if model_data.transmission.type == enum_transmission_type.DCT
        model_data.transmission.gearbox_input_torque_Nm      = datalog.transmission.dual_clutch.input_trq_Nm;
        model_data.transmission.output_torque_Nm             = datalog.transmission.output_trq_Nm;
        model_data.transmission.gearbox_output_speed_radps   = datalog.transmission.gearbox1.output_spd_radps;
    else
        model_data.transmission.gearbox_input_torque_Nm      = datalog.transmission.gearbox.input_trq_Nm;
        model_data.transmission.output_torque_Nm             = datalog.transmission.gearbox.output_trq_Nm;
        model_data.transmission.gearbox_input_speed_radps    = datalog.transmission.gearbox.input_spd_radps;
        model_data.transmission.gearbox_output_speed_radps   = datalog.transmission.gearbox.output_spd_radps;
    end
    
    if isprop(datalog.transmission,'temperature_degC')
        model_data.transmission.oil_temp_degC                = datalog.transmission.temperature_degC;
    end
    
    if isprop(datalog, 'transmission.command_line_pressure_bar')            
        model_data.transmission.line_pressure_bar            = datalog.transmission.command_line_pressure_bar;
    elseif isprop(datalog, 'command_line_pressure_bar')
        model_data.transmission.line_pressure_bar            = datalog.command_line_pressure_bar;
    end
end