% load vehicle data common to all vehicles
if isprop(vehicle.fuel,'energy_density_MJpkg')
    model_data.vehicle.fuel.energy_density_MJpkg = vehicle.fuel.energy_density_MJpkg;
end

model_data.vehicle.mass_static_kg            = vehicle.mass_static_kg;
model_data.vehicle.mass_dynamic_kg           = vehicle.mass_dynamic_kg;

model_data.vehicle.coastdown_target_A_N      = vehicle.coastdown_target_A_N;
model_data.vehicle.coastdown_target_B_Npms   = vehicle.coastdown_target_B_Npms;
model_data.vehicle.coastdown_target_C_Npms2  = vehicle.coastdown_target_C_Npms2;

model_data.vehicle.coastdown_adjust_A_N      = vehicle.coastdown_adjust_A_N;
model_data.vehicle.coastdown_adjust_B_Npms   = vehicle.coastdown_adjust_B_Npms;
model_data.vehicle.coastdown_adjust_C_Npms2  = vehicle.coastdown_adjust_C_Npms2;

model_data.vehicle.tire_rolling_radius_m     = vehicle.drive_axle1.tire.radius_m;
model_data.vehicle.accel_pedal_norm          = datalog.driver.accel_norm;
model_data.vehicle.brake_pedal_norm          = datalog.driver.brake_norm;
model_data.vehicle.dyno_distance_m           = datalog.vehicle.distance_m;
model_data.vehicle.dyno_tractive_force_N     = datalog.vehicle.output_frc_N;

model_data.vehicle.final_drive_ratio         = vehicle.drive_axle1.final_drive.gear_ratio;
model_data.vehicle.speed_mps                 = datalog.vehicle.output_spd_mps; % or could be based on tire speed...

if isprop(datalog, 'drive_cycle')
    model_data.vehicle.grade_pct                 = datalog.drive_cycle.grade_pct;
    
    model_data.vehicle.drive_cycle_speed_mps     = datalog.drive_cycle.spd_mps;
    model_data.vehicle.drive_cycle_phase         = datalog.drive_cycle.phase;
    model_data.vehicle.drive_cycle_time          = datalog.time;
    model_data.vehicle.dyno_speed_mps            = datalog.vehicle.output_spd_mps;
end

if isprop(datalog.vehicle,'axle')
    model_data.vehicle.wheel_torque_Nm           = datalog.vehicle.axle.tire.input_trq_Nm;
    model_data.vehicle.halfshaft_torque_Nm       = datalog.vehicle.axle.tire.input_trq_Nm;
else
    model_data.vehicle.wheel_torque_Nm           = datalog.vehicle.drive_axle1.tire.input_trq_Nm;
    if isprop(datalog.vehicle,'drive_axle2')
        model_data.vehicle.wheel_torque_Nm           = model_data.vehicle.wheel_torque_Nm + datalog.vehicle.drive_axle2.tire.input_trq_Nm;
    end
    if isprop(datalog.vehicle,'steer_axle')
        model_data.vehicle.wheel_torque_Nm           = model_data.vehicle.wheel_torque_Nm + datalog.vehicle.steer_axle.tire.input_trq_Nm;
    end
end

%%


