% load data for 0-60 times, J2951, etc
model_data.vehicle.mass_static_kg            = vehicle.mass_static_kg;
model_data.vehicle.coastdown_target_A_N      = vehicle.coastdown_target_A_N;
model_data.vehicle.coastdown_target_B_Npms   = vehicle.coastdown_target_B_Npms;
model_data.vehicle.coastdown_target_C_Npms2  = vehicle.coastdown_target_C_Npms2;

model_data.vehicle.coastdown_adjust_A_N      = vehicle.coastdown_adjust_A_N;
model_data.vehicle.coastdown_adjust_B_Npms   = vehicle.coastdown_adjust_B_Npms;
model_data.vehicle.coastdown_adjust_C_Npms2  = vehicle.coastdown_adjust_C_Npms2;

model_data.vehicle.drive_cycle_speed_mps     = datalog.drive_cycle.spd_mps;
model_data.vehicle.drive_cycle_phase         = datalog.drive_cycle.phase;
model_data.vehicle.drive_cycle_time          = datalog.time;
model_data.vehicle.dyno_speed_mps            = datalog.vehicle.output_spd_mps;
model_data.vehicle.speed_mps                 = datalog.vehicle.output_spd_mps;

%% Postprocess J2951 stats
% result.phase.drive_quality            = REVS_SAEJ2951(model_data, 'verbose', REVS.verbose, 'output_fid', REVS.output_fid);    
% result.phase.drive_quality_unadjusted = REVS_SAEJ2951(model_data, 'use_unadjusted_ABCs');

%% Postprocess Performance Results
if ~isempty(strfind(drive_cycle.name, 'REVS_Performance'))
    if isequal(drive_cycle.name, 'REVS_Performance') || isequal(drive_cycle.name, 'REVS_Performance_cruise75mph')
        perf_start_phase = 1;
    else
        perf_start_phase = find(strncmpi(drive_cycle.phase_name,'REVS_Performance',length('REVS_Performance')),1,'first');
    end
    
    postproc_results.performance = REVS_calc_performance_stats( datalog.time, datalog, 'start_phase', perf_start_phase, 'REVS', REVS );
    
    postproc_results.performance.total_secs =   postproc_results.performance.zero_to_sixty_time_secs + postproc_results.performance.thirty_to_fifty_time_secs + ...
        postproc_results.performance.fifty_to_seventy_time_secs +  postproc_results.performance.quarter_mile_time_secs;

end

%% gradeability calc (supposed to be in top gear, may need to adjust if not)
if ~isempty(strfind(drive_cycle.name,'REVS_Performance_cruise75mph')) && exist('engine', 'var')
    cruise_phase = find(strcmpi(drive_cycle.phase_name, 'REVS_Performance_cruise75mph_3') | strcmpi(drive_cycle.phase_name, '3'));
    
    roadload_torque_Nm = -result.phase.vehicle.final_roadload_N(cruise_phase) * vehicle.drive_axle1.tire.radius_m;
    engine_torque_capacity_Nm = interp1(engine.full_throttle_speed_radps, engine.full_throttle_torque_Nm, result.phase.engine.final_crankshaft_spd_radps(cruise_phase));
    engine_torque_reserve_Nm  = engine_torque_capacity_Nm - result.phase.engine.final_gross_trq_Nm(cruise_phase);
    wheeltorque_reserve_N = engine_torque_reserve_Nm * roadload_torque_Nm / result.phase.engine.final_crankshaft_trq_Nm(cruise_phase) / vehicle.drive_axle1.tire.radius_m;
    
    postproc_results.performance.grade_reserve_pct = tan(asin(wheeltorque_reserve_N / ambient.gravity_mps2 / vehicle.mass_static_kg)) * 100;
else
    postproc_results.performance.grade_reserve_pct = 0;
end