
cold_correction_factors = containers.Map('KeyType','char','ValueType','double');

cold_correction_factors('EPA_FTP_1.past') = 0.17;     % compare with [drive_cycle.phase_name{p} strrep(mat2str(engine.matrix_vintage),'enum_matrix_vintage','')], for example...
cold_correction_factors('EPA_FTP_2.past') = 0.025;

cold_correction_factors('EPA_FTP_1.present') = 0.15;     % compare with [drive_cycle.phase_name{p} strrep(mat2str(engine.matrix_vintage),'enum_matrix_vintage','')], for example...
cold_correction_factors('EPA_FTP_2.present') = 0.025;

cold_correction_factors('EPA_FTP_1.future') = 0.11;
cold_correction_factors('EPA_FTP_2.future') = 0.0;

cold_correction_factors('EPA_FTP4BAG_1.present') = 0.15;            % compare with [drive_cycle.phase_name{p} strrep(mat2str(engine.matrix_vintage),'enum_matrix_vintage','')], for example...
cold_correction_factors('EPA_FTP4BAG_2.present') = 0.025;

cold_correction_factors('EPA_FTP4BAG_1.present.present') = 0.15;    % compare with [drive_cycle.phase_name{p} strrep(mat2str(engine.matrix_vintage),'enum_matrix_vintage','')], for example...
cold_correction_factors('EPA_FTP4BAG_2.present.present') = 0.025;

cold_correction_factors('EPA_FTP4BAG_1.future') = 0.15; % Andy's feedback June 9 2021
cold_correction_factors('EPA_FTP4BAG_2.future') = 0.02;

cold_correction_factors('EPA_FTP_1.past.past')       = 0.17;     % past engine, past transmission
cold_correction_factors('EPA_FTP_1.past.present')    = 0.17;     % past engine, present transmission
cold_correction_factors('EPA_FTP_1.past.future')     = 0.17;     % past engine, future transmission
cold_correction_factors('EPA_FTP_1.present.past')    = 0.15;     % future engine, past transmission
cold_correction_factors('EPA_FTP_1.present.present') = 0.15;     % present engine, present transmission
cold_correction_factors('EPA_FTP_1.present.future')  = 0.15;     % present engine, future transmission
cold_correction_factors('EPA_FTP_1.future.past')     = 0.11;     % present engine, past transmission
cold_correction_factors('EPA_FTP_1.future.present')  = 0.11;     % future engine, present transmission
cold_correction_factors('EPA_FTP_1.future.future')   = 0.11;     % future engine, future transmission

cold_correction_factors('EPA_FTP_2.past.past')       = 0.025;     % past engine, past transmission
cold_correction_factors('EPA_FTP_2.past.present')    = 0.025;     % past engine, present transmission
cold_correction_factors('EPA_FTP_2.past.future')     = 0.000;     % past engine, future transmission
cold_correction_factors('EPA_FTP_2.present.past')    = 0.025;     % present engine, past transmission
cold_correction_factors('EPA_FTP_2.present.present') = 0.025;     % present engine, present transmission
cold_correction_factors('EPA_FTP_2.present.future')  = 0.000;     % present engine, future transmission
cold_correction_factors('EPA_FTP_2.future.past')     = 0.025;     % future engine, past transmission
cold_correction_factors('EPA_FTP_2.future.present')  = 0.025;     % future engine, present transmission
cold_correction_factors('EPA_FTP_2.future.future')   = 0.000;     % future engine, future transmission
    
    % Apply Cold Correction to fuel grams, gallons and MPG automatically recalculate in the fuel class

    if exist('engine','var')
        for p = 1:length(drive_cycle.phase_name)
            
            if sim_config.separate_FTP_cold_correction 
                key_str = [drive_cycle.phase_name{p} strrep(mat2str(engine.matrix_vintage),'enum_matrix_vintage','') strrep(mat2str(transmission.matrix_vintage),'enum_matrix_vintage','')];
            else
                key_str = [drive_cycle.phase_name{p} strrep(mat2str(engine.matrix_vintage),'enum_matrix_vintage','')];
            end
            
            if cold_correction_factors.isKey(key_str)
                result.phase.fuel_consumed_g(p) = result.phase.fuel_consumed_g(p) * (1 + cold_correction_factors(key_str));
            end
            
        end
    end
    