<?xml version="1.0" encoding="utf-8"?>

<!--
This is an XSL stylesheet which converts mscript XML files into HTML.
Use the XSLT command to perform the conversion.

Copyright 1984-2015 The MathWorks, Inc.
-->

<!DOCTYPE xsl:stylesheet [ <!ENTITY nbsp "&#160;"> <!ENTITY reg "&#174;"> ]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:mwsh="http://www.mathworks.com/namespace/mcode/v1/syntaxhighlight.dtd"
	exclude-result-prefixes="mwsh">
	<xsl:output method="html"
				indent="no" 
				doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>
	<xsl:strip-space elements="mwsh:code"/>
	
	<xsl:variable name="title">
	<xsl:variable name="dTitle" select="//steptitle[@style='document']"/>
		<xsl:choose>
			<xsl:when test="$dTitle"><xsl:value-of select="$dTitle"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="mscript/m-file"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	
	<xsl:template match="mscript">
		<html>
			
			<!-- head -->
			<head>
				<xsl:comment>
					This HTML was auto-generated from MATLAB code.
					To make changes, update the MATLAB code and republish this document.
				</xsl:comment>
				
				<title><xsl:value-of select="$title"/></title>
				<xsl:text>&#xa;</xsl:text>
				
				<meta name="generator">
					<xsl:attribute name="content">MATLAB <xsl:value-of select="version"/></xsl:attribute>
				</meta>
				<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />
				<meta name="DC.date">
					<xsl:attribute name="content"><xsl:value-of select="date"/></xsl:attribute>
				</meta>
				<meta name="DC.source">
					<xsl:attribute name="content"><xsl:value-of select="m-file"/>.m</xsl:attribute>
				</meta>
				
				<xsl:call-template name="stylesheet"/>
			</head>
			<xsl:text>&#xa;</xsl:text>
			<body>
				
				<xsl:call-template name="header"/>
				
				<div class="content">
					
					<!-- Determine if the there should be an introduction section. -->
					<xsl:variable name="hasIntro" select="count(cell[@style = 'overview'])"/>
					
					<!-- If there is an introduction, display it. -->
					<xsl:if test = "$hasIntro">
						
						<xsl:text>&#xa;</xsl:text>
						
						<xsl:comment>introduction</xsl:comment>
						
						<xsl:text>&#xa;</xsl:text>
						
						<xsl:apply-templates select="cell[1]/text"/>
						
						<xsl:text>&#xa;</xsl:text>
						
						<!-- There can be text output if there was a parse error. -->
						<xsl:apply-templates select="cell[1]/mcodeoutput"/>
						
						<xsl:text>&#xa;</xsl:text>
						
						<xsl:comment>/introduction</xsl:comment>
						
						<xsl:text>&#xa;</xsl:text>
						
					</xsl:if>
					
					<xsl:variable name="body-cells" select="cell[not(@style = 'overview')]"/>
					

					<!-- Loop over each cell -->
					<xsl:for-each select="$body-cells">
						
						<!-- Title of cell -->
						<xsl:comment>section</xsl:comment>
						<xsl:if test="steptitle">
							<xsl:variable name="headinglevel">
								<xsl:choose>
									<xsl:when test="steptitle[@style = 'document']">h1</xsl:when>
									<xsl:otherwise>h2</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:element name="{$headinglevel}">
								<xsl:if test="not(steptitle[@style = 'document'])">
									<xsl:attribute name="id">
										<xsl:value-of select="position()"/>
									</xsl:attribute>
								</xsl:if>
								<xsl:apply-templates select="steptitle"/>
							</xsl:element>
						</xsl:if>
						
						<!-- Contents of each cell -->
						<xsl:apply-templates select="text"/>
						
						<xsl:text>&#xa;</xsl:text>
						
						<xsl:apply-templates select="mcode-xmlized"/>
						
						<xsl:text>&#xa;</xsl:text>
						
						<xsl:apply-templates select="mcodeoutput|img"/>
						
						<xsl:text>&#xa;</xsl:text>
						
					</xsl:for-each>
					
					<xsl:call-template name="footer"/>
					
				</div>
				
				<xsl:apply-templates select="originalCode"/>
				
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="stylesheet">
		<style type="text/css">
	html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,font,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td{margin:0;padding:0;border:0;outline:0;font-size:100%;vertical-align:baseline;background:transparent}body{line-height:1}ol,ul{list-style:none}blockquote,q{quotes:none}blockquote:before,blockquote:after,q:before,q:after{content:'';content:none}:focus{outine:0}ins{text-decoration:none}del{text-decoration:line-through}table{border-collapse:collapse;border-spacing:0}

	html { min-height:100%; margin-bottom:1px; }
	html body { height:100%; margin:0px; font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000; line-height:120%; background:#fff none; overflow-y:scroll; }
	html body td { vertical-align:middle; text-align:left; }

	h1 { padding:10px; margin:0px 0px 25px; font-family:Arial, Helvetica, sans-serif; font-size:1.9em; color:#00CC33; line-height:100%; font-weight:bold; text-align:center; }
	h2 { padding:0px; margin:0px 0px 8px; font-family:Arial, Helvetica, sans-serif; font-size:1.2em; color:#0050B8; font-weight:bold; line-height:140%; border-bottom:1px solid #d6d4d4; display:block; text-align: left;}
	h3 { padding:0px; margin:0px 0px 5px; font-family:Arial, Helvetica, sans-serif; font-size:1.1em; color:#3399FF; font-weight:bold; line-height:140%; text-align: left;}

	a { color:#005fce; text-decoration:none; }
	a:hover { color:#005fce; text-decoration:underline; }
	a:visited { color:#004aa0; text-decoration:none; }

	p { padding:0px; margin:0px 0px 20px; }
	img { padding:0px; margin:0px 0px 50px; border:none; max-height:800; max-width:900; height:auto; width:auto; }
	p img, pre img, tt img, li img, h1 img, h2 img { margin-bottom:0px; } 

	ul { padding:0px; margin:0px 0px 20px 23px; list-style:square; }
	ul li { padding:0px; margin:0px 0px 7px 0px; }
	ul li ul { padding:5px 0px 0px; margin:0px 0px 7px 23px; }
	ul li ol li { list-style:decimal; }
	ol { padding:0px; margin:0px 0px 20px 0px; list-style:decimal; }
	ol li { padding:0px; margin:0px 0px 7px 23px; list-style-type:decimal; }
	ol li ol { padding:5px 0px 0px; margin:0px 0px 7px 0px; }
	ol li ol li { list-style-type:lower-alpha; }
	ol li ul { padding-top:7px; }
	ol li ul li { list-style:square; }

	.content { font-size:1.2em; line-height:120%; padding: 20px; }

	pre, code { font-size:12px; -moz-tab-size: 4; -o-tab-size: 4; tab-size: 4; text-align: left;}
	tt { font-size: 1.2em; }
	pre { margin:0px 0px 20px; }
	pre.codeinput { padding:10px; border:1px solid #d3d3d3; background:#f7f7f7; }
	pre.codeoutput { padding:10px 11px; margin:0px 0px 20px; color:#4c4c4c; }
	pre.error { color:red; }



	@media print { pre.codeinput, pre.codeoutput { word-wrap:break-word; width:98%; } }

	span.keyword { color:#0000FF }
	span.comment { color:#228B22 }
	span.string { color:#A020F0 }
	span.untermstring { color:#B20000 }
	span.syscmd { color:#B28C00 }
	span.linenum { color:#b0b0b0 }

	.footer { width:auto; padding:10px 0px; margin:25px 0px 0px; border-top:1px dotted #878787; font-size:0.8em; line-height:140%; font-style:italic; color:#878787; text-align:left; float:none; }
	.footer p { margin:0px; }
	.footer a { color:#878787; }
	.footer a:hover { color:#878787; text-decoration:underline; }
	.footer a:visited { color:#878787; }

	.header  {vertical-align:middle;line-height:100%;padding: 20px;margin:10px;}

	table th { padding:7px 5px; text-align:left; vertical-align:middle; border: 1px solid #d6d4d4; font-weight:bold; }
	table td { padding:7px 5px; text-align:left; vertical-align:middle; border:1px solid #d6d4d4; }
	</style>
	</xsl:template>
	
	<!-- Header -->
	<xsl:template name="header">
		<div>
			<a href="http://www.epa.gov">
				<img src = "data:image/svg+xml;base64,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" alt="EPA" style="float:left;border:0;padding:10px;margin:0px 15px; vertical-align:middle;"/>
			</a>
			<span style="float:right;margin:10px;">Version: <xsl:apply-templates select="date"/> </span>
			
			<h1><xsl:apply-templates select="cell[1]/steptitle"/></h1>			
		</div>
	</xsl:template>
	
	<!-- Footer -->
	<xsl:template name="footer">
		
	</xsl:template>
	
	<!-- HTML Tags in text sections -->
	<xsl:template match="p">
		<p style="clear:both">
			<xsl:apply-templates/>
		</p>
	</xsl:template>
	<xsl:template match="ul">
		<div><ul><xsl:apply-templates/></ul></div>
	</xsl:template>
	<xsl:template match="ol">
		<div><ol><xsl:apply-templates/></ol></div>
	</xsl:template>
	<xsl:template match="li">
		<li><xsl:apply-templates/></li>
	</xsl:template>
	<xsl:template match="pre">
		<xsl:choose>
			<xsl:when test="@class='error'">
				<pre class="error"><xsl:apply-templates/></pre>
			</xsl:when>
			<xsl:otherwise>
				<pre><xsl:apply-templates/></pre>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="b">
		<b><xsl:apply-templates/></b>
	</xsl:template>
	<xsl:template match="i">
		<i><xsl:apply-templates/></i>
	</xsl:template>
	<xsl:template match="tt">
		<tt><xsl:apply-templates/></tt>
	</xsl:template>
	<xsl:template match="a">
		<a>
			<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
			<xsl:apply-templates/>
		</a>
	</xsl:template>
	<xsl:template match="html">
		<xsl:value-of select="@text" disable-output-escaping="yes"/>
	</xsl:template>
	<xsl:template match="latex"/>
	
	<!-- Detecting M-Code in Comments-->
	<xsl:template match="text/mcode-xmlized">
		
		<pre class="language-matlab">
			<xsl:text>&#xa;</xsl:text>
			<xsl:apply-templates/>
			<xsl:text><!-- g162495 --></xsl:text></pre>
	</xsl:template>
	
	<!-- Code input and output -->
	<xsl:template match="mcode-xmlized">
		
		<pre class="codeinput">
			<xsl:text>&#xa;</xsl:text>
			<xsl:apply-templates/>
			<xsl:text><!-- g162495 --></xsl:text></pre>
	</xsl:template>
	
	<xsl:template match="mcodeoutput">
		
		<xsl:choose>
			<xsl:when test="concat(substring(.,0,7),substring(.,string-length(.)-7,7))='&lt;html&gt;&lt;/html&gt;'">
				<xsl:value-of select="substring(.,7,string-length(.)-14)" disable-output-escaping="yes"/>
			</xsl:when>
			<xsl:otherwise>
				<pre>
					<xsl:attribute name="class"> 
						<xsl:value-of select="@class"/>
					</xsl:attribute>
				<xsl:apply-templates/></pre>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Figure and model snapshots and equations -->
	<xsl:template match="img[@class='equation']">
		<img>
			<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
			<xsl:if test="@scale">
				<xsl:attribute name="style">
					<xsl:if test="@width">
						<xsl:text>width:</xsl:text>
						<xsl:value-of select="@width"/>
						<xsl:text>;</xsl:text>
					</xsl:if>
					<xsl:if test="@height">
						<xsl:text>height:</xsl:text><xsl:value-of select="@height"/>
						<xsl:text>;</xsl:text>
					</xsl:if>
				</xsl:attribute>
			</xsl:if>
		</img>
	</xsl:template>
	
	<xsl:template match="img">
		<img vspace="5" hspace="20">
			<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
			<xsl:if test="@width or @height">
				<xsl:attribute name="style">
					<xsl:if test="@width">
						<xsl:text>width:</xsl:text>
						<xsl:value-of select="@width"/>
						<xsl:text>;</xsl:text>
					</xsl:if>
					<xsl:if test="@height">
						<xsl:text>height:</xsl:text><xsl:value-of select="@height"/>
						<xsl:text>;</xsl:text>
					</xsl:if>
				</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
			<xsl:text> </xsl:text>
		</img>
	</xsl:template>
	
	<!-- Stash original code in HTML for easy slurping later. -->
	
	<xsl:template match="originalCode">
		<xsl:variable name="xcomment">
			<xsl:call-template name="globalReplace">
				<xsl:with-param name="outputString" select="."/>
				<xsl:with-param name="target" select="'--'"/>
				<xsl:with-param name="replacement" select="'REPLACE_WITH_DASH_DASH'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:comment>
			##### SOURCE BEGIN #####
			<xsl:value-of select="$xcomment"/>
			##### SOURCE END #####
		</xsl:comment>
	</xsl:template>
	
	<!-- Colors for syntax-highlighted input code -->
	
	<xsl:template match="mwsh:code">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="mwsh:keywords">
		<span class="keyword"><xsl:value-of select="."/></span>
	</xsl:template>
	<xsl:template match="mwsh:strings">
		<span class="string"><xsl:value-of select="."/></span>
	</xsl:template>
	<xsl:template match="mwsh:comments">
		<span class="comment"><xsl:value-of select="."/></span>
	</xsl:template>
	<xsl:template match="mwsh:unterminated_strings">
		<span class="untermstring"><xsl:value-of select="."/></span>
	</xsl:template>
	<xsl:template match="mwsh:system_commands">
		<span class="syscmd"><xsl:value-of select="."/></span>
	</xsl:template>
	
	
	<!-- Footer information -->

	
	<!-- Search and replace  -->
	<!-- From http://www.xml.com/lpt/a/2002/06/05/transforming.html -->
	
	<xsl:template name="globalReplace">
		<xsl:param name="outputString"/>
		<xsl:param name="target"/>
		<xsl:param name="replacement"/>
		<xsl:choose>
			<xsl:when test="contains($outputString,$target)">
				<xsl:value-of select=
							  "concat(substring-before($outputString,$target),$replacement)"/>
				<xsl:call-template name="globalReplace">
					<xsl:with-param name="outputString" 
									select="substring-after($outputString,$target)"/>
					<xsl:with-param name="target" select="$target"/>
					<xsl:with-param name="replacement" 
									select="$replacement"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$outputString"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
