function doc_file = REVS_publish_param_gen( gen_file )
%REVS_publish_param_gen
%	Publish specified parameter generation file into HTML and encode any inmages into the document
%   using Base64 encoding


evalin('base','clear');

close all
% evalc('run( gen_file )');

warn_stat = warning('off','backtrace');
warning('off', 'MATLAB:table:ModifiedAndSavedVarnames');

[gen_folder, gen_filename] = fileparts(which(gen_file));

% Make Intermediate and final files
% comb_m_file = [gen_folder,'\',gen_filename,'_pub.m'];
doc_file = [gen_folder,'\',gen_filename,'.html'];

pause(1)

% pub_html_base64( gen_filename, doc_file); % HTML with images inlined base64

% Find supplies
pub_tools = fileparts(which(mfilename));
	
opts.format = 'html';
% opts.figureSnapMethod = 'print';

opts.maxHeight = 800;
% opts.outputDir = [gen_folder,'\pub_temp'];
opts.stylesheet = [pub_tools,'\REVS_pub.xsl'];

pub_out = publish(gen_filename,opts);
[pub_folder, ~,~] = fileparts( pub_out);
	
fid = fopen(pub_out,'r');
pub_html_txt = fread(fid,'*char')';
fclose(fid);

[imgs_start, imgs_end] = regexp(pub_html_txt,'(?<=<img.*?src=")(?!data:).*?(?=".*?>)');

encoder = org.apache.commons.codec.binary.Base64;

for i = length(imgs_start):-1:1
	
	img_file = pub_html_txt(imgs_start(i):imgs_end(i));
	
	[~,~,img_ext] = fileparts(img_file);
	
	img_fid = fopen([pub_folder,'\',img_file],'rb');
	img_data = fread(img_fid);
	fclose(img_fid);
	
	img_base64 = char(encoder.encode(img_data))';
	
	% Replace linke with base64 data
	pub_html_txt = sprintf('%sdata:image/%s;base64,%s%s',pub_html_txt(1:(imgs_start(i)-1)),img_ext,img_base64,pub_html_txt((imgs_end(i)+1):end));
	
end

rmdir( pub_folder,'s')

fid = fopen( doc_file,'w' );
fprintf( fid, '%s',pub_html_txt);
fclose(fid);

warning(warn_stat);

end

% 
% function str = readfile( file_path )
% 
% fid = fopen( file_path , 'r+');
% str = fread( fid,inf,'char');
% fclose(fid);
% 
% end 

function pub_html_base64(pub_file, doc_file)

% Find supplies
pub_tools = fileparts(which(mfilename));
	
opts.format = 'html';
% opts.figureSnapMethod = 'print';

opts.maxHeight = 800;
% opts.outputDir = [gen_folder,'\pub_temp'];
opts.stylesheet = [pub_tools,'\REVS_pub.xsl'];

pub_out = publish(pub_file,opts);
[pub_folder, ~,~] = fileparts( pub_out);
	
fid = fopen(pub_out,'r');
pub_html_txt = fread(fid,'*char')';
fclose(fid);

[imgs_start, imgs_end] = regexp(pub_html_txt,'(?<=<img.*?src=")(?!data:).*?(?=".*?>)');

encoder = org.apache.commons.codec.binary.Base64;

for i = length(imgs_start):-1:1
	
	img_file = pub_html_txt(imgs_start(i):imgs_end(i));
	
	[~,~,img_ext] = fileparts(img_file);
	
	img_fid = fopen([pub_folder,'\',img_file],'rb');
	img_data = fread(img_fid);
	fclose(img_fid);
	
	img_base64 = char(encoder.encode(img_data))';
	
	% Replace linke with base64 data
	pub_html_txt = sprintf('%sdata:image/%s;base64,%s%s',pub_html_txt(1:(imgs_start(i)-1)),img_ext,img_base64,pub_html_txt((imgs_end(i)+1):end));
	
end

rmdir( pub_folder,'s')

fid = fopen( doc_file,'w' );
fprintf( fid, '%s',pub_html_txt);
fclose(fid);

end

