DECLARE FUNCTION filini$ (Target$, INIFile$, nlen%)
DECLARE SUB header ()
DECLARE FUNCTION NextParameter$ (cmd$)
DECLARE SUB printem (nuke$)
DECLARE FUNCTION YesNo1% (Mess$, irow%, Icol%, Resp$)
DECLARE FUNCTION resab$ (Mess$, q1$, q2$, default$)
DECLARE FUNCTION YesNo% (Mess$, irow%, Icol%, idefault%)
DEFINT I-N
DEFSNG A-H, O-Z
DIM SHARED times(150), Dlow(150, 30), Dhigh(150, 30)
DIM SHARED iage, ntim, Norg, nlet, Let$, organ$(30)
CONST true = -1
CONST False = NOT true
cx$ = "o"
CLS
PRINT TAB(30); "TABDOSE Code (6/29/00)"
PRINT TAB(30); "     K.F. Eckerman"
PRINT TAB(30); "          ORNL"
PRINT
PRINT "TABDOSE tabulates the age-specific absorbed dose rates unit activity"
PRINT "inhaled or ingested as a function of time post intake.  The file "
PRINT "TABDOSE.INI must reside in the directory with TABDOSE.EXE to provide "
PRINT "the location (path) for the files FGR13ING.DRT and FGR13INH.DRT."
PRINT "These files are compressed on the CD and must be extracted to a hard"
PRINT "disk prior to using TABDOSE."
PRINT
PRINT "The user selects either ingestion or inhalation as the route of "
PRINT "intake and identifies the nuclide of interest.  The input is not case"
PRINT "senstive.  The user can elect which coefficients are written. "
PRINT "Note: Searching the sequential data files can take time."
PRINT
Mess$ = "Tabulate In[h]aled or In[g]ested Absorbed Dose Rate [g]/h "
Resp$ = resab$(Mess$, "h", "g", "g")

IF UCASE$(Resp$) = "H" THEN
   Target$ = "Inhale"
   ext$ = "h"
ELSE
   Target$ = "Ingest"
   ext$ = "g"
END IF
PRINT
FileIn$ = filini$(Target$, "Tabdose.ini", nlen)

PRINT "Opening File "; FileIn$
PRINT
OPEN "I", #1, FileIn$
ifound = False
INPUT "Nuclide; e.g., Am-241 -> ", NukeR$
irow = CSRLIN
Icol = 1
FileOut$ = RTRIM$(NukeR$) + ext$ + ".DRT"
OPEN "O", #2, FileOut$
LINE INPUT #1, Ls$
LINE INPUT #1, Ls$
Ls$ = LTRIM$(Ls$)
dmy$ = NextParameter$(Ls$)
i = 1
DO
  organ$(i) = NextParameter$(Ls$)
  i = i + 1
LOOP WHILE LEN(Ls$) > 0
Norg = i - 1
DO
   LINE INPUT #1, nuke$
   iage = VAL(MID$(nuke$, 9, 5))
   IF ext$ = "g" THEN
      ntim = VAL(MID$(nuke$, 22, 3))
      nlet = VAL(MID$(nuke$, 26))
      Let$ = MID$(nuke$, 28)
   ELSE
      Type$ = MID$(nuke$, 19, 1)
      ntim = VAL(MID$(nuke$, 29, 3))
      nlet = VAL(MID$(nuke$, 33))
      Let$ = UCASE$(MID$(nuke$, 35))
   END IF

   IF LCASE$(RTRIM$(NukeR$)) = LCASE$(RTRIM$(LEFT$(nuke$, 7))) THEN
     IF NOT ifound THEN
       PRINT "Absorbed dose rate coefficients will be written to "; UCASE$(FileOut$)
     END IF
     ifound = true
     FOR itim = 1 TO ntim
       INPUT #1, times(itim)
       IF nlet = 1 THEN
          IF Let$ = "L" THEN
             FOR iorg = 1 TO Norg
               INPUT #1, Dlow(itim, iorg)
             NEXT iorg
          ELSEIF Let$ = "H" THEN
             FOR iorg = 1 TO Norg
               INPUT #1, Dhigh(itim, iorg)
             NEXT iorg
          END IF
       ELSE
          FOR iorg = 1 TO Norg
             INPUT #1, Dlow(itim, iorg)
          NEXT iorg
          INPUT #1, times(itim)
          FOR iorg = 1 TO Norg
             INPUT #1, Dhigh(itim, iorg)
          NEXT iorg
       END IF
     NEXT itim
     IF ext$ = "g" THEN
       IF iage = 100 THEN
          PRINT "Absorbed dose rate coefficients for infant"
       ELSEIF iage = 365 THEN
          PRINT "Absorbed dose rate coefficients for 1 y old"
       ELSEIF iage = 1825 THEN
          PRINT "Absorbed dose rate coefficients for 5 y old"
       ELSEIF iage = 3650 THEN
          PRINT "Absorbed dose rate coefficients for 10 y old"
       ELSEIF iage = 5475 THEN
          PRINT "Absorbed dose rate coefficients for 15 y old"
       ELSE
          PRINT "Absorbed dose rate coefficients for the adult"
       END IF
     ELSE
       IF iage = 100 THEN
          PRINT "Absorbed dose rate coefficients for infant: Type "; Type$
       ELSEIF iage = 365 THEN
          PRINT "Absorbed dose rate coefficients for 1 y old: Type "; Type$
       ELSEIF iage = 1825 THEN
          PRINT "Absorbed dose rate coefficients for 5 y old: Type "; Type$
       ELSEIF iage = 3650 THEN
          PRINT "Absorbed dose rate coefficients for 10 y old: Type "; Type$
       ELSEIF iage = 5475 THEN
          PRINT "Absorbed dose rate coefficients for 15 y old: Type "; Type$
       ELSE
          PRINT "Absorbed dose rate coefficients for the adult: Type "; Type$
       END IF
     END IF
     Mess$ = "Do you want to tabulate the coefficients"
     IF YesNo(Mess$, CSRLIN, 1, true) THEN
        PRINT nuke$
        CALL printem(nuke$)
     END IF
   ELSE
     IF ifound = true THEN EXIT DO
       LOCATE irow, Icol
       PRINT cx$
       IF cx$ = "o" THEN
          cx$ = "*"
       ELSE
          cx$ = "o"
       END IF
       IF Let$ = "B" THEN
          nread = 2 * ntim
       ELSE
          nread = ntim
       END IF
       FOR i = 1 TO nread
         LINE INPUT #1, Ls$
       NEXT i
   END IF
LOOP WHILE NOT EOF(1)
IF NOT ifound THEN
   PRINT "Unable to locate nuclide "; UCASE$(NukeR$)
   PRINT "Please check the FGR-13 to see if this nuclide was treated."
END IF
CLOSE
END

'************************************************
'**  Function:      Filini                     **
'**  Purpose:       File location              **
'**  Author:        K.F. Eckerman              **
'**  Language:      MS QBasic or PDS 7.1       **
'************************************************
  FUNCTION filini$ (Target$, INIFile$, nlen) STATIC
  '
  IF LEN(DIR$(INIFile$)) = 0 THEN
     PRINT
     PRINT "***** Fatal Error ******"
     PRINT " Unable to find the INI file: "; UCASE$(INIFile$)
     PRINT " The INI file needs to be in the directory "; CURDIR$
     SYSTEM
  END IF
  OPEN "i", 4, INIFile$
  Result$ = ""
  Target$ = "'" + Target$ + "'"
  Target$ = LTRIM$(RTRIM$(UCASE$(Target$)))
  ' search for the target string in the records of ini file
  DO
    INPUT #4, file$, PathFile$, nlen
    IF Target$ = LTRIM$(RTRIM$(UCASE$(file$))) THEN
       Result$ = MID$(PathFile$, 2, LEN(PathFile$) - 2)
       EXIT DO
    END IF
  LOOP WHILE NOT EOF(4)
  CLOSE 4
  IF Result$ = "" THEN
     PRINT
     PRINT "***** Fatal Error ******"
     PRINT "Unable to locate: "; UCASE$(Target$)
     PRINT "Correct the INI file "; UCASE$(INIFile$)
     SYSTEM
  ELSE
     filini$ = Result$
  END IF
  IF LEN(DIR$(Result$)) = 0 THEN
     PRINT
     PRINT "***** Fatal Error ******"
     PRINT " The path or file information is incorrect."
     PRINT " Check for proper specification for "; UCASE$(Result$)
     PRINT " Correct the INI file "; UCASE$(INIFile$)
     SYSTEM
  END IF
END FUNCTION

SUB header STATIC
  PRINT #2, " Time     ";
  FOR iorg = 1 TO Norg
           PRINT #2, USING "\       \"; organ$(iorg);
  NEXT iorg
  PRINT #2, ""
END SUB

'************************************************
'**  Name:          NextParameter$             **
'**  Type:          Function                   **
'**  Module:        QCAL.BAS                   **
'**  Language:      Microsoft QuickBASIC 4.00  **
'************************************************
  FUNCTION NextParameter$ (cmd$) STATIC
'
' Extracts parameters from the front of the
' command line.  Parameters are groups of any
' characters separated by spaces.
'
' EXAMPLE OF USE:  parm$ = NextParameter$(cmd$)
' PARAMETERS:      cmd$       The working copy of COMMAND$
' VARIABLES:       parm$      Each number or command from cmd$
' MODULE LEVEL
'   DECLARATIONS:  DECLARE FUNCTION NextParameter$ (cmd$)
'
  parm$ = ""
  DO WHILE LEFT$(cmd$, 1) <> " " AND cmd$ <> ""
     parm$ = parm$ + LEFT$(cmd$, 1)
     cmd$ = MID$(cmd$, 2)
  LOOP
  DO WHILE LEFT$(cmd$, 1) = " " AND cmd$ <> ""
     cmd$ = MID$(cmd$, 2)
  LOOP
  NextParameter$ = parm$
END FUNCTION

SUB printem (nuke$) STATIC
  PRINT #2, nuke$
  PRINT #2, RTRIM$(LEFT$(nuke$, 7)) + " Absorbed Dose Rate (Gy/s/Bq)  Age:";
  PRINT #2, iage
  IF nlet = 1 THEN
     IF Let$ = "L" THEN
        PRINT #2, "Low LET Dose Rate"
        CALL header
        FOR itim = 1 TO ntim
           PRINT #2, USING "##.##^^^^"; times(itim);
           FOR j = 1 TO Norg
             PRINT #2, USING "##.##^^^^"; Dlow(itim, j);
           NEXT j
           PRINT #2, ""
        NEXT itim
     ELSE
        PRINT #2, "High LET Dose Rate"
        CALL header
        FOR itim = 1 TO ntim
           PRINT #2, USING "##.##^^^^"; times(itim);
           FOR j = 1 TO Norg
             PRINT #2, USING "##.##^^^^"; Dhigh(itim, j);
           NEXT j
           PRINT #2, ""
        NEXT itim
     END IF
  ELSE
     PRINT #2, "Low LET Dose Rate"
     CALL header
     FOR itim = 1 TO ntim
        PRINT #2, USING "##.##^^^^"; times(itim);
        FOR j = 1 TO Norg
          PRINT #2, USING "##.##^^^^"; Dlow(itim, j);
        NEXT j
        PRINT #2, ""
     NEXT itim
     PRINT #2, "High LET Dose Rate"
     CALL header
     FOR itim = 1 TO ntim
        PRINT #2, USING "##.##^^^^"; times(itim);
        FOR j = 1 TO Norg
           PRINT #2, USING "##.##^^^^"; Dhigh(itim, j);
        NEXT j
        PRINT #2, ""
     NEXT itim
  END IF
END SUB

DEFSNG I-N
FUNCTION resab$ (Mess$, q1$, q2$, default$) STATIC
 irow = CSRLIN
 DO
    LOCATE irow
    PRINT Mess$ + "--> " + default$;
    LOCATE irow, POS(0) - 2
    INPUT " ", Resp$
    Resp$ = LCASE$(LEFT$(LTRIM$(Resp$), 1))
    IF LEN(Resp$) = 0 THEN
       resab$ = default$
       Ok = true
    ELSEIF Resp$ = RIGHT$(LCASE$(q1$), 1) THEN
       resab$ = q1$
       Ok = true
    ELSEIF Resp$ = RIGHT$(LCASE$(q2$), 1) THEN
      resab$ = q2$
       Ok = true
    ELSE
      Ok = False
      Resp$ = ""
      BEEP
    END IF
LOOP WHILE NOT Ok
END FUNCTION

'************************************************
'**  Name:          YesNo                      **
'**  Purpose:       Ask yes/no question        **
'**  Author:        K.F. Eckerman              **
'**  Language:      Microsoft QuickBASIC 4.50  **
'************************************************
FUNCTION YesNo% (Mess$, irow%, Icol%, idefault%) STATIC
  DO
     LOCATE irow%, Icol%
     PRINT Mess$;
     IF idefault% = true THEN
        PRINT " ([Y]/N)  Y";
     ELSE
        PRINT " (Y/[N])  N";
     END IF
     jcol% = POS(0)
     LOCATE irow%, jcol% - 3
     INPUT Ans$
     IF LEN(Ans$) = 0 THEN
        IF idefault% = False THEN
           Ans$ = "N"
        ELSE
           Ans$ = "Y"
        END IF
     END IF
     Ans$ = LEFT$(UCASE$(LTRIM$(Ans$)), 1)
     IF Ans$ = "Y" THEN
        YesNo% = true
        EXIT FUNCTION
     ELSEIF Ans$ = "N" THEN
        YesNo% = False
        EXIT FUNCTION
     ELSE
        Ans$ = "X"
     END IF
  LOOP WHILE Ans$ = "X"
END FUNCTION

